/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.utils.lang.IntUtils;

@Immutable
public class FlexPath {
    private final Supplier<LineString> geometrySupplier;
    public final int distanceMeters;
    public final int durationSeconds;
    private LineString geometry;

    public FlexPath(int distanceMeters, int durationSeconds, Supplier<LineString> geometrySupplier) {
        this.distanceMeters = distanceMeters;
        this.durationSeconds = IntUtils.requireNotNegative((int)durationSeconds);
        this.geometrySupplier = geometrySupplier;
    }

    public LineString getGeometry() {
        if (this.geometry == null) {
            this.geometry = this.geometrySupplier.get();
        }
        return this.geometry;
    }

    public FlexPath withTimePenalty(TimePenalty penalty) {
        int updatedDuration = (int)penalty.calculate(Duration.ofSeconds(this.durationSeconds)).toSeconds();
        return new FlexPath(this.distanceMeters, updatedDuration, this.geometrySupplier);
    }
}

