/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.street.model.vertex.Vertex;

public class DirectFlexPathCalculator
implements FlexPathCalculator {
    public static final double FLEX_SPEED = 8.0;
    private static final int DIRECT_EXTRA_TIME = 300;
    private final double flexSpeed;

    public DirectFlexPathCalculator() {
        this.flexSpeed = 8.0;
    }

    @Override
    public FlexPath calculateFlexPath(Vertex fromv, Vertex tov, int boardStopPosition, int alightStopPosition) {
        double distance = SphericalDistanceLibrary.distance(fromv.getCoordinate(), tov.getCoordinate());
        LineString geometry = GeometryUtils.getGeometryFactory().createLineString(new Coordinate[]{fromv.getCoordinate(), tov.getCoordinate()});
        return new FlexPath((int)distance, (int)(distance / this.flexSpeed) + 300, () -> geometry);
    }
}

