/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.filter;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.modes.ExcludeAllTransitFilter;
import org.opentripplanner.routing.api.request.request.filter.AllowAllTransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.api.request.TripRequestBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FilterMapper {
    private final List<FeedScopedId> excludedAgencies = new ArrayList<FeedScopedId>();
    private final List<FeedScopedId> excludedRoutes = new ArrayList<FeedScopedId>();
    private final List<FeedScopedId> selectedAgencies = new ArrayList<FeedScopedId>();
    private final List<FeedScopedId> selectedRoutes = new ArrayList<FeedScopedId>();

    private FilterMapper() {
    }

    public static TripRequest map(List<TransitFilter> filters) {
        FilterMapper mapper = new FilterMapper();
        return mapper.mapFilters(filters);
    }

    private TripRequest mapFilters(List<TransitFilter> filters) {
        TripRequestBuilder builder = TripRequest.of();
        for (TransitFilter filter : filters) {
            if (filter instanceof TransitFilterRequest) {
                TransitFilterRequest sr = (TransitFilterRequest)filter;
                this.addFilter(sr);
                continue;
            }
            if (filter instanceof AllowAllTransitFilter || filter instanceof ExcludeAllTransitFilter) continue;
            throw new IllegalStateException("Unexpected value: " + String.valueOf(filter));
        }
        if (!this.selectedAgencies.isEmpty()) {
            builder.withIncludeAgencies(this.selectedAgencies);
        }
        if (!this.selectedRoutes.isEmpty()) {
            builder.withIncludeRoutes(this.selectedRoutes);
        }
        if (!this.excludedAgencies.isEmpty()) {
            builder.withExcludeAgencies(this.excludedAgencies);
        }
        if (!this.excludedRoutes.isEmpty()) {
            builder.withExcludeRoutes(this.excludedRoutes);
        }
        return builder.build();
    }

    private void addFilter(TransitFilterRequest sr) {
        sr.not().forEach(s -> {
            this.excludedRoutes.addAll(s.routes());
            this.excludedAgencies.addAll(s.agencies());
        });
        sr.select().forEach(s -> {
            this.selectedRoutes.addAll(s.routes());
            this.selectedAgencies.addAll(s.agencies());
        });
    }
}

