/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.flex.FlexibleTransitLegBuilder;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class FlexibleTransitLeg
implements TransitLeg {
    private final FlexTripEdge edge;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final Set<TransitAlert> transitAlerts;
    private final int generalizedCost;
    private final Emission emissionPerPerson;
    private final List<FareOffer> fareOffers;

    FlexibleTransitLeg(FlexibleTransitLegBuilder builder) {
        this.edge = Objects.requireNonNull(builder.flexTripEdge());
        this.startTime = Objects.requireNonNull(builder.startTime());
        this.endTime = Objects.requireNonNull(builder.endTime());
        this.generalizedCost = builder.generalizedCost();
        this.transitAlerts = Set.copyOf(builder.alerts());
        this.fareOffers = List.copyOf(builder.fareOffers());
        this.emissionPerPerson = builder.emissionPerPerson();
    }

    public static FlexibleTransitLegBuilder of() {
        return new FlexibleTransitLegBuilder();
    }

    public FlexibleTransitLegBuilder copyOf() {
        return new FlexibleTransitLegBuilder(this);
    }

    @Override
    public Agency agency() {
        return this.trip().getRoute().getAgency();
    }

    @Override
    @Nullable
    public Operator operator() {
        return this.trip().getOperator();
    }

    @Override
    public Route route() {
        return this.trip().getRoute();
    }

    @Override
    public Trip trip() {
        return this.edge.getFlexTrip().getTrip();
    }

    @Override
    public Accessibility tripWheelchairAccessibility() {
        return this.edge.getFlexTrip().getTrip().getWheelchairBoarding();
    }

    @Override
    public LegCallTime start() {
        return LegCallTime.ofStatic(this.startTime);
    }

    @Override
    public LegCallTime end() {
        return LegCallTime.ofStatic(this.endTime);
    }

    @Override
    public TransitMode mode() {
        return this.trip().getMode();
    }

    @Override
    public ZonedDateTime startTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime endTime() {
        return this.endTime;
    }

    @Override
    public boolean isFlexibleTrip() {
        return true;
    }

    @Override
    public double distanceMeters() {
        return DoubleUtils.roundTo2Decimals((double)this.edge.getDistanceMeters());
    }

    @Override
    public Integer routeType() {
        return this.trip().getRoute().getGtfsType();
    }

    @Override
    public I18NString headsign() {
        return this.trip().getHeadsign();
    }

    @Override
    public LocalDate serviceDate() {
        return this.edge.serviceDate();
    }

    @Override
    public Place from() {
        return Place.forFlexStop(this.edge.s1(), this.edge.getFromVertex());
    }

    @Override
    public Place to() {
        return Place.forFlexStop(this.edge.s2(), this.edge.getToVertex());
    }

    @Override
    public List<StopArrival> listIntermediateStops() {
        return List.of();
    }

    @Override
    public LineString legGeometry() {
        return this.edge.getGeometry();
    }

    @Override
    public Set<TransitAlert> listTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public TransitLeg decorateWithAlerts(Set<TransitAlert> alerts) {
        return this.copyOf().withAlerts(alerts).build();
    }

    @Override
    public TransitLeg decorateWithFareOffers(List<FareOffer> fares) {
        return this.copyOf().withFareProducts(fares).build();
    }

    @Override
    public PickDrop boardRule() {
        return this.edge.getFlexTrip().getBoardRule(this.boardStopPosInPattern());
    }

    @Override
    public PickDrop alightRule() {
        return this.edge.getFlexTrip().getAlightRule(this.alightStopPosInPattern());
    }

    @Override
    public BookingInfo dropOffBookingInfo() {
        return this.edge.getFlexTrip().getDropOffBookingInfo(this.alightStopPosInPattern());
    }

    @Override
    public BookingInfo pickupBookingInfo() {
        return this.edge.getFlexTrip().getPickupBookingInfo(this.boardStopPosInPattern());
    }

    @Override
    public Integer boardStopPosInPattern() {
        return this.edge.boardStopPosInPattern();
    }

    @Override
    public Integer alightStopPosInPattern() {
        return this.edge.alightStopPosInPattern();
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    public Leg withTimeShift(Duration duration) {
        return this.copyOf().withStartTime(this.startTime.plus(duration)).withEndTime(this.endTime.plus(duration)).build();
    }

    @Override
    @Nullable
    public Emission emissionPerPerson() {
        return this.emissionPerPerson;
    }

    @Override
    @Nullable
    public Leg withEmissionPerPerson(Emission emissionPerPerson) {
        return this.copyOf().withEmissionPerPerson(emissionPerPerson).build();
    }

    @Override
    public List<FareOffer> fareOffers() {
        return this.fareOffers;
    }

    public String toString() {
        return ToStringBuilder.of(FlexibleTransitLeg.class).addObj("from", (Object)this.from()).addObj("to", (Object)this.to()).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addNum("distance", (Number)this.distanceMeters(), "m").addNum("cost", (Number)this.generalizedCost).addObjOp("agencyId", (Object)this.agency(), AbstractTransitEntity::getId).addObjOp("routeId", (Object)this.route(), AbstractTransitEntity::getId).addObjOp("tripId", (Object)this.trip(), AbstractTransitEntity::getId).addObj("serviceDate", (Object)this.serviceDate()).addObj("legGeometry", (Object)this.legGeometry()).addCol("transitAlerts", this.transitAlerts).addNum("boardingStopIndex", (Number)this.boardStopPosInPattern()).addNum("alightStopIndex", (Number)this.alightStopPosInPattern()).addEnum("boardRule", (Enum)this.boardRule()).addEnum("alightRule", (Enum)this.alightRule()).addObj("pickupBookingInfo", (Object)this.pickupBookingInfo()).addObj("dropOffBookingInfo", (Object)this.dropOffBookingInfo()).toString();
    }

    FlexTripEdge flexTripEdge() {
        return this.edge;
    }
}

