/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.flexpathcalculator.DirectFlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.StreetFlexPathCalculator;
import org.opentripplanner.ext.flex.template.DirectFlexPath;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexAccessFactory;
import org.opentripplanner.ext.flex.template.FlexDirectPathFactory;
import org.opentripplanner.ext.flex.template.FlexEgressFactory;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.filter.transit.TripMatcherFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class FlexRouter {
    private final Graph graph;
    private final TransitService transitService;
    private final FlexParameters flexParameters;
    private final Collection<NearbyStop> streetAccesses;
    private final Collection<NearbyStop> streetEgresses;
    private final FlexIndex flexIndex;
    private final FlexPathCalculator accessFlexPathCalculator;
    private final FlexPathCalculator egressFlexPathCalculator;
    private final GraphPathToItineraryMapper graphPathToItineraryMapper;
    private final FlexAccessEgressCallbackAdapter callbackService;
    private final ZonedDateTime startOfTime;
    private final int requestedTime;
    private final int requestedBookingTime;
    private final List<FlexServiceDate> dates;
    private final Matcher<Trip> matcher;

    public FlexRouter(Graph graph, TransitService transitService, FlexParameters flexParameters, TripRequest filterRequest, Instant requestedTime, @Nullable Instant requestedBookingTime, int additionalPastSearchDays, int additionalFutureSearchDays, Collection<NearbyStop> streetAccesses, Collection<NearbyStop> egressTransfers) {
        this.graph = graph;
        this.transitService = transitService;
        this.flexParameters = flexParameters;
        this.streetAccesses = streetAccesses;
        this.streetEgresses = egressTransfers;
        this.flexIndex = transitService.getFlexIndex();
        this.matcher = TripMatcherFactory.of(filterRequest, transitService.getCalendarService()::getServiceDatesForServiceId);
        this.callbackService = new CallbackAdapter();
        this.graphPathToItineraryMapper = new GraphPathToItineraryMapper(transitService.getTimeZone(), graph.streetNotesService, graph.ellipsoidToGeoidDifference);
        if (graph.hasStreets) {
            this.accessFlexPathCalculator = new StreetFlexPathCalculator(false, flexParameters.maxFlexTripDuration());
            this.egressFlexPathCalculator = new StreetFlexPathCalculator(true, flexParameters.maxFlexTripDuration());
        } else {
            this.accessFlexPathCalculator = new DirectFlexPathCalculator();
            this.egressFlexPathCalculator = new DirectFlexPathCalculator();
        }
        ZoneId tz = transitService.getTimeZone();
        LocalDate searchDate = LocalDate.ofInstant(requestedTime, tz);
        this.startOfTime = ServiceDateUtils.asStartOfService((LocalDate)searchDate, (ZoneId)tz);
        this.requestedTime = ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)this.startOfTime, (Instant)requestedTime);
        this.requestedBookingTime = requestedBookingTime == null ? -1999999 : ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)this.startOfTime, (Instant)requestedBookingTime);
        this.dates = this.createFlexServiceDates(transitService, additionalPastSearchDays, additionalFutureSearchDays, searchDate);
    }

    public List<Itinerary> createFlexOnlyItineraries(boolean arriveBy) {
        OTPRequestTimeoutException.checkForTimeout();
        Collection<DirectFlexPath> directFlexPaths = new FlexDirectPathFactory(this.callbackService, this.accessFlexPathCalculator, this.egressFlexPathCalculator, this.flexParameters.maxTransferDuration(), this.matcher).calculateDirectFlexPaths(this.streetAccesses, this.streetEgresses, this.dates, this.requestedTime, arriveBy);
        ArrayList<Itinerary> itineraries = new ArrayList<Itinerary>();
        for (DirectFlexPath it : directFlexPaths) {
            ZonedDateTime startTime = this.startOfTime.plusSeconds(it.startTime());
            Itinerary itinerary = this.graphPathToItineraryMapper.generateItinerary(new GraphPath<State, Edge, Vertex>(it.state())).withTimeShiftToStartAt(startTime);
            if (itinerary == null) continue;
            itineraries.add(itinerary);
        }
        return itineraries;
    }

    public Collection<FlexAccessEgress> createFlexAccesses() {
        OTPRequestTimeoutException.checkForTimeout();
        return new FlexAccessFactory(this.callbackService, this.accessFlexPathCalculator, this.flexParameters.maxTransferDuration(), this.matcher).createFlexAccesses(this.streetAccesses, this.dates);
    }

    public Collection<FlexAccessEgress> createFlexEgresses() {
        OTPRequestTimeoutException.checkForTimeout();
        return new FlexEgressFactory(this.callbackService, this.egressFlexPathCalculator, this.flexParameters.maxTransferDuration(), this.matcher).createFlexEgresses(this.streetEgresses, this.dates);
    }

    private List<FlexServiceDate> createFlexServiceDates(TransitService transitService, int additionalPastSearchDays, int additionalFutureSearchDays, LocalDate searchDate) {
        ArrayList<FlexServiceDate> dates = new ArrayList<FlexServiceDate>();
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            LocalDate date = searchDate.plusDays(d);
            dates.add(new FlexServiceDate(date, ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)this.startOfTime, (LocalDate)date), this.requestedBookingTime, transitService.getServiceCodesRunningForDate(date)));
        }
        return List.copyOf(dates);
    }

    private class CallbackAdapter
    implements FlexAccessEgressCallbackAdapter {
        private CallbackAdapter() {
        }

        @Override
        public TransitStopVertex getStopVertex(FeedScopedId stopId) {
            return FlexRouter.this.graph.getStopVertex(stopId);
        }

        @Override
        public Collection<PathTransfer> getTransfersFromStop(StopLocation stop) {
            return FlexRouter.this.transitService.getFlexIndex().getTransfersFromStop(stop);
        }

        @Override
        public Collection<PathTransfer> getTransfersToStop(StopLocation stop) {
            return FlexRouter.this.transitService.getFlexIndex().getTransfersToStop(stop);
        }

        @Override
        public Collection<FlexTrip<?, ?>> getFlexTripsByStop(StopLocation stopLocation) {
            return FlexRouter.this.flexIndex.getFlexTripsByStop(stopLocation);
        }

        @Override
        public boolean isDateActive(FlexServiceDate date, FlexTrip<?, ?> trip) {
            int serviceCode = FlexRouter.this.transitService.getServiceCode(trip.getTrip().getServiceId());
            return date.isTripServiceRunning(serviceCode);
        }
    }
}

