/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import org.opentripplanner.utils.time.DurationUtils;

public record FlexPathDurations(int access, int trip, int egress, int offset) {
    public FlexPathDurations {
        if (access < 0) {
            throw new IllegalArgumentException("The access duration must be 0 or a positive number.");
        }
        if (trip < 0) {
            throw new IllegalArgumentException("The trip duration must be 0 or a positive number.");
        }
        if (egress < 0) {
            throw new IllegalArgumentException("The egress duration must be 0 or a positive number.");
        }
    }

    public int total() {
        return this.access + this.trip + this.egress;
    }

    public int mapToFlexTripDepartureTime(int routerDepartureTime) {
        return this.toFlexTime(routerDepartureTime + this.access);
    }

    public int mapToRouterDepartureTime(int flexTripDepartureTime) {
        return this.toRouterTime(flexTripDepartureTime - this.access);
    }

    public int mapToFlexTripArrivalTime(int routerArrivalTime) {
        return this.toFlexTime(routerArrivalTime - this.egress);
    }

    public int mapToRouterArrivalTime(int flexTripArrivalTime) {
        return this.toRouterTime(flexTripArrivalTime + this.egress);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("(");
        buf.append(DurationUtils.durationToStr((int)this.access)).append(" + ");
        buf.append(DurationUtils.durationToStr((int)this.trip)).append(" + ");
        buf.append(DurationUtils.durationToStr((int)this.egress));
        if (this.offset != 0) {
            buf.append(", offset: ").append(DurationUtils.durationToStr((int)this.offset));
        }
        return buf.append(")").toString();
    }

    private int toFlexTime(int routerTime) {
        return routerTime - this.offset;
    }

    private int toRouterTime(int flexTripTime) {
        return flexTripTime + this.offset;
    }
}

