/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TimetableRepository;

public class FlexIndex {
    private final Multimap<StopLocation, PathTransfer> transfersToStop = ArrayListMultimap.create();
    private final Multimap<StopLocation, PathTransfer> transfersFromStop = ArrayListMultimap.create();
    private final Multimap<StopLocation, FlexTrip<?, ?>> flexTripsByStop = HashMultimap.create();
    private final Map<FeedScopedId, Route> routeById = new HashMap<FeedScopedId, Route>();
    private final Map<FeedScopedId, FlexTrip<?, ?>> tripById = new HashMap();

    public FlexIndex(TimetableRepository timetableRepository) {
        for (PathTransfer pathTransfer : timetableRepository.findTransfers(StreetMode.WALK)) {
            this.transfersToStop.put((Object)pathTransfer.to, (Object)pathTransfer);
            this.transfersFromStop.put((Object)pathTransfer.from, (Object)pathTransfer);
        }
        for (FlexTrip flexTrip : timetableRepository.getAllFlexTrips()) {
            this.routeById.put(flexTrip.getTrip().getRoute().getId(), flexTrip.getTrip().getRoute());
            this.tripById.put(flexTrip.getTrip().getId(), flexTrip);
            for (StopLocation stop : flexTrip.getStops()) {
                if (stop instanceof GroupStop) {
                    GroupStop groupStop = (GroupStop)stop;
                    for (StopLocation stopElement : groupStop.getChildLocations()) {
                        this.flexTripsByStop.put((Object)stopElement, (Object)flexTrip);
                    }
                    continue;
                }
                this.flexTripsByStop.put((Object)stop, (Object)flexTrip);
            }
        }
    }

    public Collection<PathTransfer> getTransfersToStop(StopLocation stopLocation) {
        return this.transfersToStop.get((Object)stopLocation);
    }

    public Collection<PathTransfer> getTransfersFromStop(StopLocation stopLocation) {
        return this.transfersFromStop.get((Object)stopLocation);
    }

    public Collection<FlexTrip<?, ?>> getFlexTripsByStop(StopLocation stopLocation) {
        return this.flexTripsByStop.get((Object)stopLocation);
    }

    public boolean contains(Route route) {
        return this.routeById.containsKey(route.getId());
    }

    public Collection<Route> getAllFlexRoutes() {
        return this.routeById.values();
    }

    public FlexTrip<?, ?> getTripById(FeedScopedId id) {
        return this.tripById.get(id);
    }

    public Collection<FlexTrip<?, ?>> getAllFlexTrips() {
        return this.tripById.values();
    }
}

