/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.util.Objects;
import org.opentripplanner.ext.flex.FlexPathDurations;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.booking.RoutingBookingInfo;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class FlexAccessEgress {
    private final RegularStop stop;
    private final FlexPathDurations pathDurations;
    private final int boardStopPosition;
    private final int alightStopPosition;
    private final FlexTrip<?, ?> trip;
    private final State lastState;
    private final boolean stopReachedOnBoard;
    private final RoutingBookingInfo routingBookingInfo;

    public FlexAccessEgress(RegularStop stop, FlexPathDurations pathDurations, int boardStopPosition, int alightStopPosition, FlexTrip<?, ?> trip, State lastState, boolean stopReachedOnBoard, int requestedBookingTime) {
        this.stop = stop;
        this.pathDurations = pathDurations;
        this.boardStopPosition = boardStopPosition;
        this.alightStopPosition = alightStopPosition;
        this.trip = Objects.requireNonNull(trip);
        this.lastState = lastState;
        this.stopReachedOnBoard = stopReachedOnBoard;
        this.routingBookingInfo = RoutingBookingInfo.of(requestedBookingTime, trip.getPickupBookingInfo(boardStopPosition));
    }

    public RegularStop stop() {
        return this.stop;
    }

    public State lastState() {
        return this.lastState;
    }

    public boolean stopReachedOnBoard() {
        return this.stopReachedOnBoard;
    }

    public int earliestDepartureTime(int departureTime) {
        int tripDepartureTime = this.pathDurations.mapToFlexTripDepartureTime(departureTime);
        int earliestDepartureTime = this.trip.earliestDepartureTime(tripDepartureTime = this.routingBookingInfo.earliestDepartureTime(tripDepartureTime), this.boardStopPosition, this.alightStopPosition, this.pathDurations.trip());
        if (earliestDepartureTime == -999) {
            return -999;
        }
        return this.pathDurations.mapToRouterDepartureTime(earliestDepartureTime);
    }

    public int latestArrivalTime(int arrivalTime) {
        int tripArrivalTime = this.pathDurations.mapToFlexTripArrivalTime(arrivalTime);
        int latestArrivalTime = this.trip.latestArrivalTime(tripArrivalTime, this.boardStopPosition, this.alightStopPosition, this.pathDurations.trip());
        if (latestArrivalTime == -999) {
            return -999;
        }
        if (this.routingBookingInfo.exceedsMinimumBookingNotice(latestArrivalTime - this.pathDurations.trip())) {
            return -999;
        }
        return this.pathDurations.mapToRouterArrivalTime(latestArrivalTime);
    }

    public String toString() {
        return ToStringBuilder.of(FlexAccessEgress.class).addNum("boardStopPosition", (Number)this.boardStopPosition).addNum("alightStopPosition", (Number)this.alightStopPosition).addObj("durations", (Object)this.pathDurations).addObj("stop", (Object)this.stop).addObj("trip", (Object)this.trip.getId()).addObj("lastState", (Object)this.lastState).addBoolIfTrue("stopReachedOnBoard", Boolean.valueOf(this.stopReachedOnBoard)).toString();
    }
}

