/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaStopsToVerticesMapper
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(AreaStopsToVerticesMapper.class);
    private final Graph graph;
    private final TimetableRepository timetableRepository;

    @Inject
    public AreaStopsToVerticesMapper(Graph graph, TimetableRepository timetableRepository) {
        this.graph = graph;
        this.timetableRepository = timetableRepository;
    }

    @Override
    public void buildGraph() {
        if (!this.timetableRepository.getSiteRepository().hasAreaStops()) {
            return;
        }
        ProgressTracker progress = ProgressTracker.track((String)"Add flex locations to street vertices", (int)1, (long)this.timetableRepository.getSiteRepository().listAreaStops().size());
        LOG.info(progress.startMessage());
        Stream results = this.timetableRepository.getSiteRepository().listAreaStops().parallelStream().flatMap(areaStop -> {
            Stream<MatchResult> matchedVertices = AreaStopsToVerticesMapper.matchingVerticesForStop(this.graph, areaStop);
            progress.step(m -> LOG.info(m));
            return matchedVertices;
        });
        ImmutableMultimap mappedResults = (ImmutableMultimap)results.collect(ImmutableListMultimap.flatteningToImmutableListMultimap(MatchResult::vertex, mr -> Stream.of(mr.stop())));
        mappedResults.keySet().forEach(vertex -> vertex.addAreaStops((Collection<AreaStop>)mappedResults.get(vertex)));
        LOG.info(progress.completeMessage());
    }

    private static Stream<MatchResult> matchingVerticesForStop(Graph graph, AreaStop areaStop) {
        return graph.findVertices(areaStop.getGeometry().getEnvelopeInternal()).stream().filter(StreetVertex.class::isInstance).map(StreetVertex.class::cast).filter(StreetVertex::isEligibleForCarPickupDropoff).filter(vertx -> {
            Point p = GeometryUtils.getGeometryFactory().createPoint(vertx.getCoordinate());
            return areaStop.getGeometry().intersects((Geometry)p);
        }).map(vertx -> new MatchResult((StreetVertex)vertx, areaStop));
    }

    private record MatchResult(StreetVertex vertex, AreaStop stop) {
    }
}

