/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.fares.model.FareTransferRule;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareTransferRuleBuilder {
    private FeedScopedId id;
    private FeedScopedId fromLegGroup;
    private FeedScopedId toLegGroup;
    private int transferCount = -1;
    private Duration timeLimit;
    private Collection<FareProduct> fareProducts = List.of();

    FareTransferRuleBuilder() {
    }

    public FareTransferRuleBuilder withId(FeedScopedId id) {
        this.id = id;
        return this;
    }

    public FareTransferRuleBuilder withFromLegGroup(FeedScopedId fromLegGroup) {
        this.fromLegGroup = fromLegGroup;
        return this;
    }

    public FareTransferRuleBuilder withToLegGroup(FeedScopedId toLegGroup) {
        this.toLegGroup = toLegGroup;
        return this;
    }

    public FareTransferRuleBuilder withTransferCount(int transferCount) {
        this.transferCount = transferCount;
        return this;
    }

    public FareTransferRuleBuilder withTimeLimit(Duration timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public FareTransferRuleBuilder withFareProducts(Collection<FareProduct> fareProducts) {
        this.fareProducts = fareProducts;
        return this;
    }

    public FeedScopedId id() {
        return this.id;
    }

    public FeedScopedId fromLegGroup() {
        return this.fromLegGroup;
    }

    public FeedScopedId toLegGroup() {
        return this.toLegGroup;
    }

    public int transferCount() {
        return this.transferCount;
    }

    public Duration timeLimit() {
        return this.timeLimit;
    }

    public Collection<FareProduct> fareProducts() {
        return this.fareProducts;
    }

    public FareTransferRule build() {
        return new FareTransferRule(this);
    }
}

