/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.ext.fares.model.FareTransferRuleBuilder;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class FareTransferRule
implements Serializable {
    public static final int UNLIMITED_TRANSFERS = -1;
    private final FeedScopedId id;
    @Nullable
    private final FeedScopedId fromLegGroup;
    @Nullable
    private final FeedScopedId toLegGroup;
    private final int transferCount;
    @Nullable
    private final Duration timeLimit;
    private final Collection<FareProduct> fareProducts;

    FareTransferRule(FareTransferRuleBuilder b) {
        this.id = Objects.requireNonNull(b.id());
        this.fareProducts = List.copyOf(b.fareProducts());
        this.fromLegGroup = b.fromLegGroup();
        this.toLegGroup = b.toLegGroup();
        this.transferCount = b.transferCount();
        this.timeLimit = b.timeLimit();
    }

    public boolean isFree() {
        return this.fareProducts.isEmpty() || this.fareProducts.stream().allMatch(p -> p.price().isZero());
    }

    public boolean containsWildCard() {
        return this.fromLegGroup == null || this.toLegGroup == null;
    }

    public boolean unlimitedTransfers() {
        return this.transferCount == -1;
    }

    public FeedScopedId id() {
        return this.id;
    }

    @Nullable
    public FeedScopedId fromLegGroup() {
        return this.fromLegGroup;
    }

    @Nullable
    public FeedScopedId toLegGroup() {
        return this.toLegGroup;
    }

    public Collection<FareProduct> fareProducts() {
        return this.fareProducts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FareTransferRule that = (FareTransferRule)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.fromLegGroup, that.fromLegGroup) && Objects.equals(this.toLegGroup, that.toLegGroup) && this.transferCount == that.transferCount && Objects.equals(this.timeLimit, that.timeLimit) && Objects.equals(this.fareProducts, that.fareProducts);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fromLegGroup, this.toLegGroup, this.transferCount, this.timeLimit, this.fareProducts);
    }

    public String toString() {
        return ToStringBuilder.of(FareTransferRule.class).addObj("id", (Object)this.id).addObj("fromLegGroup", (Object)this.fromLegGroup).addObj("toLegGroup", (Object)this.toLegGroup).addNum("transferCount", (Number)this.transferCount).addDuration("timeLimit", this.timeLimit).addCol("fareProducts", this.fareProducts).toString();
    }

    public static FareTransferRuleBuilder of() {
        return new FareTransferRuleBuilder();
    }
}

