/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.RouteOriginDestination;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareRuleSet
implements Serializable {
    private FeedScopedId agency = null;
    private final Set<FeedScopedId> routes;
    private final Set<OriginDestination> originDestinations;
    private final Set<RouteOriginDestination> routeOriginDestinations;
    private final Set<String> contains;
    private final FareAttribute fareAttribute;

    public FareRuleSet(FareAttribute fareAttribute) {
        this.fareAttribute = fareAttribute;
        this.routes = new HashSet<FeedScopedId>();
        this.originDestinations = new HashSet<OriginDestination>();
        this.routeOriginDestinations = new HashSet<RouteOriginDestination>();
        this.contains = new HashSet<String>();
    }

    public void addOriginDestination(String origin, String destination) {
        this.originDestinations.add(new OriginDestination(origin, destination));
    }

    public void addRouteOriginDestination(String route, String origin, String destination) {
        this.routeOriginDestinations.add(new RouteOriginDestination(route, origin, destination));
    }

    public Set<RouteOriginDestination> getRouteOriginDestinations() {
        return this.routeOriginDestinations;
    }

    public boolean hasRules() {
        return !this.routes.isEmpty() || !this.originDestinations.isEmpty() || !this.routeOriginDestinations.isEmpty() || !this.contains.isEmpty();
    }

    public void addContains(String containsId) {
        this.contains.add(containsId);
    }

    public Set<String> getContains() {
        return this.contains;
    }

    public void addRoute(FeedScopedId route) {
        this.routes.add(route);
    }

    public Set<FeedScopedId> getRoutes() {
        return this.routes;
    }

    public FareAttribute getFareAttribute() {
        return this.fareAttribute;
    }

    public boolean matches(String startZone, String endZone, Set<String> zonesVisited, Set<FeedScopedId> routesVisited, Set<FeedScopedId> tripsVisited, int transfersUsed, Duration tripTime, Duration journeyTime) {
        OriginDestination od2;
        OriginDestination od;
        if (!(this.originDestinations.isEmpty() || this.originDestinations.contains(od = new OriginDestination(startZone, endZone)) || this.originDestinations.contains(od2 = new OriginDestination(od.origin, null)) || this.originDestinations.contains(od2 = new OriginDestination(null, od.origin)))) {
            return false;
        }
        if (!this.contains.isEmpty() && !zonesVisited.equals(this.contains)) {
            return false;
        }
        if (!this.routes.isEmpty() && !this.routes.containsAll(routesVisited)) {
            return false;
        }
        if (this.fareAttribute.isTransfersSet() && this.fareAttribute.getTransfers() < transfersUsed) {
            return false;
        }
        if (this.fareAttribute.isTransferDurationSet() && tripTime.getSeconds() > (long)this.fareAttribute.getTransferDuration().intValue()) {
            return false;
        }
        return !this.fareAttribute.isJourneyDurationSet() || journeyTime.getSeconds() <= (long)this.fareAttribute.getJourneyDuration().intValue();
    }

    public boolean hasAgencyDefined() {
        return this.agency != null;
    }

    public FeedScopedId getAgency() {
        return this.agency;
    }

    public void setAgency(FeedScopedId agency) {
        this.agency = agency;
    }

    record OriginDestination(String origin, String destination) {
    }
}

