/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.util.Objects;
import org.opentripplanner.ext.fares.model.FareAttributeBuilder;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public final class FareAttribute
extends AbstractTransitEntity<FareAttribute, FareAttributeBuilder> {
    private FeedScopedId agency;
    private final Money price;
    private final int paymentMethod;
    private final Integer transfers;
    private final Integer transferDuration;
    private final Integer journeyDuration;

    FareAttribute(FareAttributeBuilder builder) {
        super(builder.getId());
        this.price = Objects.requireNonNull(builder.price());
        this.paymentMethod = builder.paymentMethod();
        this.transfers = builder.transfers();
        this.transferDuration = builder.transferDuration();
        this.journeyDuration = builder.journeyDuration();
        this.agency = builder.agency();
    }

    public static FareAttributeBuilder of(FeedScopedId id) {
        return new FareAttributeBuilder(id);
    }

    public FeedScopedId getAgency() {
        return this.agency;
    }

    public void setAgency(FeedScopedId agency) {
        this.agency = agency;
    }

    public Money getPrice() {
        return this.price;
    }

    public int getPaymentMethod() {
        return this.paymentMethod;
    }

    public boolean isTransfersSet() {
        return this.transfers != null;
    }

    public Integer getTransfers() {
        return this.transfers;
    }

    public boolean isTransferDurationSet() {
        return this.transferDuration != null;
    }

    public Integer getTransferDuration() {
        return this.transferDuration;
    }

    public boolean isJourneyDurationSet() {
        return this.journeyDuration != null;
    }

    public Integer getJourneyDuration() {
        return this.journeyDuration;
    }

    @Override
    public boolean sameAs(FareAttribute other) {
        return this.getId().equals(other.getId()) && this.getPrice().equals(other.getPrice()) && this.paymentMethod == other.getPaymentMethod() && Objects.equals(this.transfers, other.getTransfers()) && Objects.equals(this.transferDuration, other.getTransferDuration()) && Objects.equals(this.journeyDuration, other.getJourneyDuration());
    }

    public FareAttributeBuilder copy() {
        return new FareAttributeBuilder(this);
    }
}

