/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;

class LegOfferContainer {
    private final SetMultimap<Leg, FareOffer> multimap = HashMultimap.create();

    LegOfferContainer() {
    }

    public void transferProducts(ScheduledTransitLeg from, List<ScheduledTransitLeg> targets) {
        Set previousLegsProducts = this.multimap.get((Object)from);
        targets.forEach(leg -> this.addToLeg((ScheduledTransitLeg)leg, previousLegsProducts));
    }

    void addToLeg(ScheduledTransitLeg leg, Collection<FareOffer> products) {
        products.forEach(p -> this.addToLeg((Leg)leg, (FareOffer)p));
    }

    void addToLeg(Leg leg, FareOffer offer) {
        Optional<FareOffer> legContainsItAlready = this.multimap.get((Object)leg).stream().filter(existingOffer -> existingOffer.fareProduct().equals(offer.fareProduct())).findAny();
        if (legContainsItAlready.isPresent()) {
            FareOffer existing = legContainsItAlready.get();
            if (existing.startTime().isAfter(offer.startTime())) {
                this.multimap.remove((Object)leg, (Object)existing);
                this.multimap.put((Object)leg, (Object)offer);
            }
        } else {
            this.multimap.put((Object)leg, (Object)offer);
        }
    }

    SetMultimap<Leg, FareOffer> toMultimap() {
        return ImmutableSetMultimap.copyOf(this.multimap);
    }
}

