/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.fares.impl.gtfs.FareLookupService;
import org.opentripplanner.ext.fares.impl.gtfs.FareResult;
import org.opentripplanner.ext.fares.impl.gtfs.LegOfferContainer;
import org.opentripplanner.ext.fares.model.FareLegRule;
import org.opentripplanner.ext.fares.model.FareTransferRule;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.collection.ListUtils;

public final class GtfsFaresV2Service
implements Serializable {
    private final FareLookupService lookup;

    public GtfsFaresV2Service(List<FareLegRule> legRules, List<FareTransferRule> fareTransferRules, Multimap<FeedScopedId, FeedScopedId> stopAreas) {
        this.lookup = new FareLookupService(legRules, fareTransferRules, stopAreas);
    }

    public FareResult calculateFares(Itinerary itinerary) {
        LegOfferContainer legOffers = new LegOfferContainer();
        List<ScheduledTransitLeg> scheduledTransitLegs = itinerary.listScheduledTransitLegs();
        scheduledTransitLegs.forEach(leg -> {
            Set<FareOffer> products = this.lookup.legRules((ScheduledTransitLeg)leg).stream().flatMap(r -> r.fareProducts().stream()).map(fp -> FareOffer.of(leg.startTime(), fp)).collect(Collectors.toUnmodifiableSet());
            legOffers.addToLeg((ScheduledTransitLeg)leg, (Collection<FareOffer>)products);
        });
        if (scheduledTransitLegs.size() > 1) {
            List splits = ListUtils.partitionIntoSplits(scheduledTransitLegs);
            splits.forEach(split -> split.subTails().forEach(legs -> {
                Set<FareOffer> offers = this.lookup.findTransferOffersForSubLegs((ScheduledTransitLeg)split.head(), (List<ScheduledTransitLeg>)legs);
                legs.forEach(leg -> legOffers.addToLeg((ScheduledTransitLeg)leg, (Collection<FareOffer>)offers));
                boolean hasFreeTransfer = this.lookup.hasFreeTransfer((ScheduledTransitLeg)split.head(), (List<ScheduledTransitLeg>)legs);
                if (hasFreeTransfer) {
                    legOffers.transferProducts((ScheduledTransitLeg)split.head(), (List<ScheduledTransitLeg>)legs);
                }
            }));
        }
        Set<FareProduct> itinProducts = this.lookup.findTransfersMatchingAllLegs(scheduledTransitLegs);
        return new FareResult(itinProducts, (Multimap<Leg, FareOffer>)legOffers.toMultimap());
    }

    boolean isEmpty() {
        return this.lookup.isEmpty();
    }
}

