/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.google.common.collect.Multimap;
import java.util.Objects;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.impl.gtfs.FareResult;
import org.opentripplanner.ext.fares.impl.gtfs.GtfsFaresV2Service;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.fares.FareService;

public record GtfsFaresService(DefaultFareService faresV1, GtfsFaresV2Service faresV2) implements FareService
{
    @Override
    public ItineraryFare calculateFares(Itinerary itinerary) {
        ItineraryFare fare = ItineraryFare.empty();
        if (this.faresV2.isEmpty()) {
            fare = Objects.requireNonNullElse(this.faresV1.calculateFares(itinerary), ItineraryFare.empty());
        } else {
            FareResult products = this.faresV2.calculateFares(itinerary);
            fare.addItineraryProducts(products.itineraryProducts());
            if (products.itineraryProducts().isEmpty()) {
                GtfsFaresService.addLegProducts(products.legProducts(), fare);
            }
        }
        return fare;
    }

    private static void addLegProducts(Multimap<Leg, FareOffer> legProducts, ItineraryFare fares) {
        legProducts.entries().forEach(e -> fares.addFareProduct((Leg)e.getKey(), (FareOffer)e.getValue()));
    }
}

