/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.fares.impl.gtfs.TransferMatch;
import org.opentripplanner.ext.fares.model.FareDistance;
import org.opentripplanner.ext.fares.model.FareLegRule;
import org.opentripplanner.ext.fares.model.FareTransferRule;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.transit.model.basic.Distance;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.collection.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FareLookupService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(FareLookupService.class);
    private final List<FareLegRule> legRules;
    private final List<FareTransferRule> transferRules;
    private final SetMultimap<FeedScopedId, FeedScopedId> stopAreas;
    private final Set<FeedScopedId> networksWithRules;
    private final Set<FeedScopedId> fromAreasWithRules;
    private final Set<FeedScopedId> toAreasWithRules;
    private List<FareLegRule> fromRules;

    FareLookupService(List<FareLegRule> legRules, List<FareTransferRule> fareTransferRules, Multimap<FeedScopedId, FeedScopedId> stopAreas) {
        this.legRules = List.copyOf(legRules);
        this.transferRules = FareLookupService.stripWildcards(fareTransferRules);
        this.networksWithRules = FareLookupService.findNetworksWithRules(legRules);
        this.fromAreasWithRules = FareLookupService.findAreasWithRules(legRules, FareLegRule::fromAreaId);
        this.toAreasWithRules = FareLookupService.findAreasWithRules(legRules, FareLegRule::toAreaId);
        this.stopAreas = ImmutableSetMultimap.copyOf(stopAreas);
    }

    boolean isEmpty() {
        return this.legRules.isEmpty() && this.transferRules.isEmpty();
    }

    Set<FareLegRule> legRules(ScheduledTransitLeg leg) {
        return this.legRules.stream().filter(r -> this.legMatchesRule(leg, (FareLegRule)r)).collect(Collectors.toSet());
    }

    Set<FareProduct> findTransfersMatchingAllLegs(List<ScheduledTransitLeg> legs) {
        return this.transferRules.stream().filter(FareTransferRule::unlimitedTransfers).filter(FareTransferRule::isFree).flatMap(r -> this.findTransferMatches((FareTransferRule)r, legs).stream()).filter(transferMatch -> this.appliesToAllLegs(legs, (TransferMatch)transferMatch)).flatMap(transferRule -> transferRule.fromLegRule().fareProducts().stream()).collect(Collectors.toUnmodifiableSet());
    }

    private boolean appliesToAllLegs(List<ScheduledTransitLeg> legs, TransferMatch transferMatch) {
        return ListUtils.partitionIntoOverlappingPairs(legs).stream().allMatch(pair -> this.legMatchesRule((ScheduledTransitLeg)pair.first(), transferMatch.fromLegRule()) && this.legMatchesRule((ScheduledTransitLeg)pair.second(), transferMatch.toLegRule()));
    }

    Set<FareOffer> findTransferOffersForSubLegs(ScheduledTransitLeg head, List<ScheduledTransitLeg> tail) {
        Set<TransferMatch> rules = this.transferRules.stream().flatMap(r -> {
            this.fromRules = this.findFareLegRule(r.fromLegGroup());
            List<FareLegRule> toRules = this.findFareLegRule(r.toLegGroup());
            if (this.fromRules.isEmpty() || toRules.isEmpty()) {
                return Stream.of(new TransferMatch[0]);
            }
            Set<Set<TransferMatch>> possibleTransfers = this.findPossibleTransfers(head, tail, (FareTransferRule)r, this.fromRules, toRules);
            return SetUtils.intersection(possibleTransfers).stream();
        }).collect(Collectors.toSet());
        HashMultimap dependencies = HashMultimap.create();
        rules.forEach(arg_0 -> FareLookupService.lambda$findTransferOffersForSubLegs$7((Multimap)dependencies, arg_0));
        return dependencies.keySet().stream().map(arg_0 -> FareLookupService.lambda$findTransferOffersForSubLegs$8(head, (Multimap)dependencies, arg_0)).collect(Collectors.toSet());
    }

    boolean hasFreeTransfer(ScheduledTransitLeg head, List<ScheduledTransitLeg> tail) {
        return this.transferRules.stream().anyMatch(r -> {
            List<FareLegRule> fromRules = this.findFareLegRule(r.fromLegGroup());
            List<FareLegRule> toRules = this.findFareLegRule(r.toLegGroup());
            if (fromRules.isEmpty() || toRules.isEmpty()) {
                return false;
            }
            return tail.stream().allMatch(to -> this.findTransferMatches(head, (ScheduledTransitLeg)to, (FareTransferRule)r, fromRules, toRules).anyMatch(t -> t.transferRule().isFree()));
        });
    }

    private Set<Set<TransferMatch>> findPossibleTransfers(ScheduledTransitLeg head, List<ScheduledTransitLeg> tail, FareTransferRule r, List<FareLegRule> fromRules, List<FareLegRule> toRules) {
        return tail.stream().map(to -> this.findTransferMatches(head, (ScheduledTransitLeg)to, r, fromRules, toRules).collect(Collectors.toUnmodifiableSet())).collect(Collectors.toUnmodifiableSet());
    }

    private Stream<TransferMatch> findTransferMatches(ScheduledTransitLeg from, ScheduledTransitLeg to, FareTransferRule r, List<FareLegRule> fromRules, List<FareLegRule> toRules) {
        return fromRules.stream().flatMap(fromRule -> toRules.stream().map(toRule -> new TransferMatch(r, (FareLegRule)fromRule, (FareLegRule)toRule))).filter(match -> this.legMatchesRule(from, match.fromLegRule()) && this.legMatchesRule(to, match.toLegRule()));
    }

    private List<TransferMatch> findTransferMatches(FareTransferRule transferRule, List<ScheduledTransitLeg> transitLegs) {
        List pairs = ListUtils.partitionIntoOverlappingPairs(transitLegs);
        List<FareLegRule> fromRules = this.findFareLegRule(transferRule.fromLegGroup());
        List<FareLegRule> toRules = this.findFareLegRule(transferRule.toLegGroup());
        if (pairs.isEmpty() || fromRules.isEmpty() || toRules.isEmpty()) {
            return List.of();
        }
        return pairs.stream().flatMap(pair -> {
            ScheduledTransitLeg from = (ScheduledTransitLeg)pair.first();
            ScheduledTransitLeg to = (ScheduledTransitLeg)pair.second();
            List<FareLegRule> matchingFrom = fromRules.stream().filter(rule -> this.legMatchesRule(from, (FareLegRule)rule)).toList();
            List<FareLegRule> matchingTo = toRules.stream().filter(rule -> this.legMatchesRule(to, (FareLegRule)rule)).toList();
            return matchingFrom.stream().flatMap(fromR -> matchingTo.stream().map(toR -> new TransferMatch(transferRule, (FareLegRule)fromR, (FareLegRule)toR)));
        }).toList();
    }

    private boolean legMatchesRule(ScheduledTransitLeg leg, FareLegRule rule) {
        return leg.agency().getId().getFeedId().equals(rule.feedId()) && this.matchesNetworkId(leg, rule) && this.matchesArea(leg.from().stop, rule.fromAreaId(), this.fromAreasWithRules) && this.matchesArea(leg.to().stop, rule.toAreaId(), this.toAreasWithRules) && this.matchesDistance(leg, rule);
    }

    private List<FareLegRule> findFareLegRule(FeedScopedId id) {
        return this.legRules.stream().filter(r -> r.legGroupId().equals(id)).toList();
    }

    private static List<FareTransferRule> stripWildcards(Collection<FareTransferRule> rules) {
        return rules.stream().filter(FareLookupService::checkForWildcards).toList();
    }

    private static boolean checkForWildcards(FareTransferRule t) {
        if (t.containsWildCard()) {
            LOG.warn("Transfer rule {} contains a wildcard leg group reference. These are not supported yet.", (Object)t);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesArea(StopLocation stop, FeedScopedId areaId, Set<FeedScopedId> areasWithRules) {
        Set stopAreas = this.stopAreas.get((Object)stop.getId());
        if (Objects.isNull(areaId)) {
            if (stopAreas.stream().noneMatch(areasWithRules::contains)) return true;
        }
        if (!Objects.nonNull(areaId)) return false;
        if (!stopAreas.contains(areaId)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesNetworkId(ScheduledTransitLeg leg, FareLegRule rule) {
        List<FeedScopedId> routesNetworkIds = leg.route().getGroupsOfRoutes().stream().map(AbstractTransitEntity::getId).filter(Objects::nonNull).toList();
        if (Objects.isNull(rule.networkId())) {
            if (this.networksWithRules.stream().noneMatch(routesNetworkIds::contains)) return true;
        }
        if (!routesNetworkIds.contains(rule.networkId())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesDistance(ScheduledTransitLeg leg, FareLegRule rule) {
        Distance min;
        Distance distance2;
        FareDistance distance = rule.fareDistance();
        if (distance instanceof FareDistance.Stops) {
            int n;
            FareDistance.Stops stops = (FareDistance.Stops)distance;
            int min2 = n = stops.min();
            int max = n = stops.max();
            int numStops = leg.listIntermediateStops().size();
            if (numStops < min2) return false;
            if (max < numStops) return false;
            return true;
        }
        FareDistance numStops = rule.fareDistance();
        if (!(numStops instanceof FareDistance.LinearDistance)) return true;
        FareDistance.LinearDistance linearDistance = (FareDistance.LinearDistance)numStops;
        try {
            min = distance2 = linearDistance.min();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Distance max = distance2 = linearDistance.max();
        double legDistance = leg.directDistanceMeters();
        if (!(legDistance > (double)min.toMeters())) return false;
        if (!(legDistance < (double)max.toMeters())) return false;
        return true;
    }

    private static Set<FeedScopedId> findAreasWithRules(List<FareLegRule> legRules, Function<FareLegRule, FeedScopedId> getArea) {
        return legRules.stream().map(getArea).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Set<FeedScopedId> findNetworksWithRules(Collection<FareLegRule> legRules) {
        return legRules.stream().map(FareLegRule::networkId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static /* synthetic */ FareOffer lambda$findTransferOffersForSubLegs$8(ScheduledTransitLeg head, Multimap dependencies, FareProduct product) {
        return FareOffer.of(head.startTime(), product, dependencies.get((Object)product));
    }

    private static /* synthetic */ void lambda$findTransferOffersForSubLegs$7(Multimap dependencies, TransferMatch transfer) {
        transfer.transferRule().fareProducts().forEach(p -> dependencies.putAll(p, transfer.fromLegRule().fareProducts()));
    }
}

