/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.impl.gtfs.GtfsFaresService;
import org.opentripplanner.ext.fares.impl.gtfs.GtfsFaresV2Service;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareLegRule;
import org.opentripplanner.ext.fares.model.FareRule;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.ext.fares.model.FareTransferRule;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFareServiceFactory
implements FareServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFareServiceFactory.class);
    protected Map<FeedScopedId, FareRuleSet> regularFareRules = new HashMap<FeedScopedId, FareRuleSet>();
    private final List<FareLegRule> fareLegRules = new ArrayList<FareLegRule>();
    private final List<FareTransferRule> fareTransferRules = new ArrayList<FareTransferRule>();
    private final Multimap<FeedScopedId, FeedScopedId> stopAreas = ArrayListMultimap.create();

    @Override
    public FareService makeFareService() {
        DefaultFareService fareService = new DefaultFareService();
        fareService.addFareRules(FareType.regular, this.regularFareRules.values());
        GtfsFaresV2Service faresV2Service = new GtfsFaresV2Service(this.fareLegRules, this.fareTransferRules, this.stopAreas);
        return new GtfsFaresService(fareService, faresV2Service);
    }

    @Override
    public void processGtfs(FareRulesData fareRulesData, OtpTransitService transitService) {
        this.fillFareRules(fareRulesData.fareAttributes(), fareRulesData.fareRules(), this.regularFareRules);
        this.fareLegRules.addAll(fareRulesData.fareLegRules());
        this.fareTransferRules.addAll(fareRulesData.fareTransferRules());
        this.stopAreas.putAll(fareRulesData.stopAreas());
    }

    @Override
    public void configure(JsonNode config) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected void fillFareRules(Collection<FareAttribute> fareAttributes, Collection<FareRule> fareRules, Map<FeedScopedId, FareRuleSet> fareRuleSet) {
        for (FareAttribute fare : fareAttributes) {
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fareRule != null) continue;
            fareRule = new FareRuleSet(fare);
            fareRuleSet.put(id, fareRule);
        }
        for (FareRule rule : fareRules) {
            Route route;
            FareAttribute fare = rule.getFare();
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fareRule == null) {
                LOG.error("Nonexistent fare ID in fare rule: " + String.valueOf(id));
                continue;
            }
            String contains = rule.getContainsId();
            if (contains != null) {
                fareRule.addContains(contains);
            }
            String origin = rule.getOriginId();
            String destination = rule.getDestinationId();
            if (origin != null || destination != null) {
                fareRule.addOriginDestination(origin, destination);
            }
            if ((route = rule.getRoute()) == null) continue;
            FeedScopedId routeId = route.getId();
            fareRule.addRoute(routeId);
        }
    }
}

