/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.fares.impl.gtfs.CombinedInterlinedTransitLeg;
import org.opentripplanner.ext.fares.impl.gtfs.FareAndId;
import org.opentripplanner.ext.fares.impl.gtfs.FareSearch;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.FareZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFareService
implements FareService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFareService.class);
    protected Map<FareType, Collection<FareRuleSet>> fareRulesPerType = new HashMap<FareType, Collection<FareRuleSet>>();

    public void addFareRules(FareType fareType, Collection<FareRuleSet> fareRules) {
        this.fareRulesPerType.put(fareType, new ArrayList<FareRuleSet>(fareRules));
    }

    public Map<FareType, Collection<FareRuleSet>> getFareRulesPerType() {
        return this.fareRulesPerType;
    }

    protected Map<String, List<Leg>> fareLegsByFeed(List<Leg> fareLegs) {
        return fareLegs.stream().collect(Collectors.groupingBy(leg -> leg.agency().getId().getFeedId()));
    }

    @Override
    public ItineraryFare calculateFares(Itinerary itinerary) {
        List<Leg> fareLegs = itinerary.legs().stream().filter(l -> l instanceof ScheduledTransitLeg || l instanceof FlexibleTransitLeg).toList();
        if ((fareLegs = this.combineInterlinedLegs(fareLegs)).isEmpty()) {
            return null;
        }
        Map<String, List<Leg>> fareLegsByFeed = this.fareLegsByFeed(fareLegs);
        ItineraryFare fare = ItineraryFare.empty();
        for (FareType fareType : this.fareRulesPerType.keySet()) {
            for (String feedId : fareLegsByFeed.keySet()) {
                Collection<FareRuleSet> fareRules = this.fareRulesForFeed(fareType, feedId);
                if (fareRules == null || fareRules.isEmpty()) continue;
                Currency currency = fareRules.iterator().next().getFareAttribute().getPrice().currency();
                ItineraryFare computedFaresForType = this.calculateFaresForType(currency, fareType, fareLegsByFeed.get(feedId), fareRules);
                fare.add(computedFaresForType);
            }
        }
        return fare;
    }

    @Nullable
    protected Collection<FareRuleSet> fareRulesForFeed(FareType fareType, String feedId) {
        Map<FareType, Map> fareRulesByTypeAndFeed = this.fareRulesPerType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, rules -> ((Collection)rules.getValue()).stream().collect(Collectors.groupingBy(rule -> rule.getFareAttribute().getId().getFeedId()))));
        return (Collection)fareRulesByTypeAndFeed.get(fareType).get(feedId);
    }

    protected ItineraryFare calculateFaresForType(Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        FareSearch r = this.performSearch(fareType, legs, fareRules);
        LinkedHashMultimap fareProductUses = LinkedHashMultimap.create();
        int start = 0;
        int end = legs.size() - 1;
        while (start <= end) {
            while (start <= end && r.endOfComponent[start] < 0) {
                ++start;
            }
            if (start > end) break;
            int via = r.next[start][r.endOfComponent[start]];
            float cost = r.resultTable[start][via];
            FeedScopedId fareId = r.fareIds[start][via];
            FareProduct product = FareProduct.of(fareId, fareType.name(), Money.ofFractionalAmount(currency, cost)).build();
            ArrayList<Leg> applicableLegs = new ArrayList<Leg>();
            for (int i = start; i <= via; ++i) {
                Leg leg = legs.get(i);
                if (leg instanceof CombinedInterlinedTransitLeg) {
                    CombinedInterlinedTransitLeg combinedLeg = (CombinedInterlinedTransitLeg)leg;
                    applicableLegs.addAll(combinedLeg.originalLegs());
                    continue;
                }
                applicableLegs.add(leg);
            }
            if (!applicableLegs.isEmpty()) {
                FareOffer offer = FareOffer.of(((Leg)applicableLegs.getFirst()).startTime(), product);
                applicableLegs.forEach(arg_0 -> DefaultFareService.lambda$calculateFaresForType$4((Multimap)fareProductUses, offer, arg_0));
            }
            start = via + 1;
        }
        ItineraryFare fare = ItineraryFare.empty();
        fare.addFareProductUses((Multimap<Leg, FareOffer>)fareProductUses);
        return fare;
    }

    protected Optional<Money> calculateCost(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        return this.getBestFareAndId(fareType, rides, fareRules).map(FareAndId::fare);
    }

    protected Optional<FareAndId> getBestFareAndId(FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        HashSet<String> zones = new HashSet<String>();
        HashSet<FeedScopedId> routes = new HashSet<FeedScopedId>();
        HashSet<FeedScopedId> trips = new HashSet<FeedScopedId>();
        int transfersUsed = -1;
        Leg firstRide = legs.get(0);
        ZonedDateTime startTime = firstRide.startTime();
        String startZone = firstRide.from().stop.getFirstZoneAsString();
        String endZone = null;
        String feedId = firstRide.agency().getId().getFeedId();
        ZonedDateTime lastRideStartTime = null;
        ZonedDateTime lastRideEndTime = null;
        for (Leg leg : legs) {
            if (!leg.agency().getId().getFeedId().equals(feedId)) {
                LOG.debug("skipped multi-feed ride sequence {}", legs);
                return Optional.empty();
            }
            lastRideStartTime = leg.startTime();
            lastRideEndTime = leg.endTime();
            endZone = leg.to().stop.getFirstZoneAsString();
            routes.add(leg.route().getId());
            trips.add(leg.trip().getId());
            for (FareZone z : leg.fareZones()) {
                zones.add(z.getId().getId());
            }
            ++transfersUsed;
        }
        FareAttribute bestAttribute = null;
        Money bestFare = null;
        Duration tripTime = Duration.between(startTime, lastRideStartTime);
        Duration journeyTime = Duration.between(startTime, lastRideEndTime);
        for (FareRuleSet ruleSet : fareRules) {
            FareAttribute attribute2 = ruleSet.getFareAttribute();
            if (!attribute2.getId().getFeedId().equals(feedId) || !ruleSet.matches(startZone, endZone, zones, routes, trips, transfersUsed, tripTime, journeyTime)) continue;
            Money newFare = attribute2.getPrice();
            if (bestFare != null && !newFare.lessThan(bestFare)) continue;
            bestAttribute = attribute2;
            bestFare = newFare;
        }
        LOG.debug("{} best for {}", bestAttribute, legs);
        Money finalBestFare = bestFare;
        return Optional.ofNullable(bestAttribute).map(attribute -> new FareAndId(finalBestFare, attribute.getId()));
    }

    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg previousLeg, ScheduledTransitLeg currentLeg) {
        return false;
    }

    private List<Leg> combineInterlinedLegs(List<Leg> fareLegs) {
        ArrayList<Leg> result = new ArrayList<Leg>();
        for (Leg leg : fareLegs) {
            if (leg.isInterlinedWithPreviousLeg().booleanValue() && leg instanceof ScheduledTransitLeg) {
                ScheduledTransitLeg previousLeg;
                ScheduledTransitLeg currentLeg = (ScheduledTransitLeg)leg;
                Leg leg2 = result.get(result.size() - 1);
                if (leg2 instanceof ScheduledTransitLeg && this.shouldCombineInterlinedLegs(previousLeg = (ScheduledTransitLeg)leg2, currentLeg)) {
                    CombinedInterlinedTransitLeg combinedLeg = new CombinedInterlinedTransitLeg(previousLeg, currentLeg);
                    result.set(result.size() - 1, combinedLeg);
                    continue;
                }
            }
            result.add(leg);
        }
        return result;
    }

    private FareSearch performSearch(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = new FareSearch(rides.size());
        for (int i = 0; i < rides.size(); ++i) {
            for (int j = 0; j < rides.size() - i; ++j) {
                Optional<FareAndId> best = this.getBestFareAndId(fareType, rides.subList(j, j + i + 1), fareRules);
                float cost = best.map(b -> Float.valueOf(b.fare().fractionalAmount().floatValue())).orElse(Float.valueOf(Float.POSITIVE_INFINITY)).floatValue();
                if (cost < 0.0f) {
                    LOG.error("negative cost for a ride sequence");
                    cost = Float.POSITIVE_INFINITY;
                }
                if (cost < Float.POSITIVE_INFINITY) {
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = j + i;
                }
                r.resultTable[j][j + i] = cost;
                r.fareIds[j][j + i] = best.map(FareAndId::fareId).orElse(null);
                for (int k = 0; k < i; ++k) {
                    float via = r.resultTable[j][j + k] + r.resultTable[j + k + 1][j + i];
                    if (!(r.resultTable[j][j + i] > via)) continue;
                    r.resultTable[j][j + i] = via;
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = r.next[j][j + k];
                }
            }
        }
        return r;
    }

    private static /* synthetic */ void lambda$calculateFaresForType$4(Multimap fareProductUses, FareOffer offer, Leg leg) {
        fareProductUses.put((Object)leg, (Object)offer);
    }
}

