/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl.gtfs;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.LegCallTime;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.utils.collection.ListUtils;

class CombinedInterlinedTransitLeg
implements TransitLeg {
    private final TransitLeg first;
    private final TransitLeg second;

    public CombinedInterlinedTransitLeg(TransitLeg first, TransitLeg second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Agency agency() {
        return this.first.agency();
    }

    @Override
    public TransitMode mode() {
        return this.first.mode();
    }

    @Override
    public Route route() {
        return this.first.route();
    }

    @Override
    public Trip trip() {
        return this.first.trip();
    }

    @Override
    public LegCallTime start() {
        return this.first.start();
    }

    @Override
    public LegCallTime end() {
        return this.second.end();
    }

    @Override
    public ZonedDateTime startTime() {
        return this.first.startTime();
    }

    @Override
    public ZonedDateTime endTime() {
        return this.second.startTime();
    }

    @Override
    public double distanceMeters() {
        return this.first.distanceMeters() + this.second.distanceMeters();
    }

    @Override
    public Place from() {
        return this.first.from();
    }

    @Override
    public Place to() {
        return this.second.to();
    }

    @Override
    public List<StopArrival> listIntermediateStops() {
        return ListUtils.combine((Collection[])new Collection[]{this.first.listIntermediateStops(), this.second.listIntermediateStops()});
    }

    @Override
    @Nullable
    public LineString legGeometry() {
        return null;
    }

    @Override
    public Set<TransitAlert> listTransitAlerts() {
        return Set.of();
    }

    @Override
    public int generalizedCost() {
        if (this.first.generalizedCost() == -1) {
            return this.second.generalizedCost();
        }
        if (this.second.generalizedCost() == -1) {
            return this.first.generalizedCost();
        }
        return this.first.generalizedCost() + this.second.generalizedCost();
    }

    @Override
    public Set<FareZone> fareZones() {
        Set<FareZone> fareZones = this.first.fareZones();
        fareZones.addAll(this.second.fareZones());
        return fareZones;
    }

    @Override
    public List<FareOffer> fareOffers() {
        return List.of();
    }

    public List<Leg> originalLegs() {
        return List.of(this.first, this.second);
    }

    @Override
    @Nullable
    public Emission emissionPerPerson() {
        return null;
    }

    @Override
    @Nullable
    public Leg withEmissionPerPerson(Emission emissionPerPerson) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransitLeg decorateWithAlerts(Set<TransitAlert> alerts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransitLeg decorateWithFareOffers(List<FareOffer> fares) {
        throw new UnsupportedOperationException();
    }
}

