/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.fare.FareMedium;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.fare.RiderCategory;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;

public class OrcaFareService
extends DefaultFareService {
    private static final Duration MAX_TRANSFER_DISCOUNT_DURATION = Duration.ofHours(2L);
    public static final String COMM_TRANS_AGENCY_ID = "29";
    public static final String COMM_TRANS_FLEX_AGENCY_ID = "4969";
    public static final String KC_METRO_AGENCY_ID = "1";
    public static final String SOUND_TRANSIT_AGENCY_ID = "40";
    public static final String T_LINK_AGENCY_ID = "F1";
    public static final String EVERETT_TRANSIT_AGENCY_ID = "97";
    public static final String PIERCE_COUNTY_TRANSIT_AGENCY_ID = "3";
    public static final String SKAGIT_TRANSIT_AGENCY_ID = "e0e4541a-2714-487b-b30c-f5c6cb4a310f";
    public static final String SEATTLE_STREET_CAR_AGENCY_ID = "23";
    public static final String WASHINGTON_STATE_FERRIES_AGENCY_ID = "95";
    public static final String KITSAP_TRANSIT_AGENCY_ID = "kt";
    public static final String WHATCOM_AGENCY_ID = "14";
    public static final int ROUTE_TYPE_FERRY = 4;
    public static final String FEED_ID = "orca";
    private static final FareMedium ELECTRONIC_MEDIUM = new FareMedium(new FeedScopedId("orca", "electronic"), "electronic");
    private static final FareMedium CASH_MEDIUM = new FareMedium(new FeedScopedId("orca", "cash"), "cash");
    private static final LocalDate KITSAP_FAST_FERRY_CHANGE_DATE = LocalDate.of(2025, 10, 1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RideType getRideType(Leg leg) {
        RideType rideType;
        RideType rideType2;
        String agencyId = leg.agency().getId().getId();
        Route route = leg.route();
        String tripId = leg.trip().getId().getId();
        switch (agencyId) {
            case "29": 
            case "4969": {
                try {
                    RideType rideType3;
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 500 && routeId < 600) {
                        RideType rideType4;
                        rideType2 = rideType4 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                    rideType2 = rideType3 = RideType.COMM_TRANS_LOCAL_SWIFT;
                    return rideType2;
                }
                catch (NumberFormatException e) {
                    RideType rideType5;
                    rideType2 = rideType5 = RideType.COMM_TRANS_LOCAL_SWIFT;
                    return rideType2;
                }
            }
            case "1": {
                RideType rideType6;
                try {
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 500 && routeId < 600) {
                        RideType rideType7;
                        rideType2 = rideType7 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                }
                catch (NumberFormatException routeId) {
                    // empty catch block
                }
                if ("973".equals(route.getShortName())) {
                    RideType rideType8;
                    rideType2 = rideType8 = RideType.KC_WATER_TAXI_WEST_SEATTLE;
                    return rideType2;
                }
                if ("975".equals(route.getShortName())) {
                    RideType rideType9;
                    rideType2 = rideType9 = RideType.KC_WATER_TAXI_VASHON_ISLAND;
                    return rideType2;
                }
                rideType2 = rideType6 = RideType.KC_METRO;
                return rideType2;
            }
            case "3": {
                try {
                    RideType rideType10;
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 520 && routeId < 600) {
                        RideType rideType11;
                        rideType2 = rideType11 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                    rideType2 = rideType10 = RideType.PIERCE_COUNTY_TRANSIT;
                    return rideType2;
                }
                catch (NumberFormatException e) {
                    RideType rideType12;
                    rideType2 = rideType12 = RideType.PIERCE_COUNTY_TRANSIT;
                    return rideType2;
                }
            }
            case "40": {
                RideType rideType13;
                rideType2 = rideType13 = RideType.SOUND_TRANSIT;
                return rideType2;
            }
            case "97": {
                RideType rideType14;
                rideType2 = rideType14 = RideType.EVERETT_TRANSIT;
                return rideType2;
            }
            case "e0e4541a-2714-487b-b30c-f5c6cb4a310f": {
                RideType rideType15;
                rideType2 = rideType15 = Set.of("80X", "90X").contains(route.getShortName()) ? RideType.SKAGIT_CROSS_COUNTY : RideType.SKAGIT_LOCAL;
                return rideType2;
            }
            case "23": {
                RideType rideType16;
                rideType2 = rideType16 = RideType.SEATTLE_STREET_CAR;
                return rideType2;
            }
            case "95": {
                RideType rideType17;
                rideType2 = rideType17 = RideType.WASHINGTON_STATE_FERRIES;
                return rideType2;
            }
            case "F1": {
                RideType rideType18;
                rideType2 = rideType18 = RideType.SOUND_TRANSIT_T_LINK;
                return rideType2;
            }
            case "kt": {
                RideType rideType19;
                if (route.getGtfsType() == 4) {
                    if (tripId.contains("east")) {
                        RideType rideType20;
                        rideType2 = rideType20 = RideType.KITSAP_TRANSIT_FAST_FERRY_EASTBOUND;
                        return rideType2;
                    }
                    if (tripId.contains("west")) {
                        RideType rideType21;
                        rideType2 = rideType21 = RideType.KITSAP_TRANSIT_FAST_FERRY_WESTBOUND;
                        return rideType2;
                    }
                }
                rideType2 = rideType19 = RideType.KITSAP_TRANSIT;
                return rideType2;
            }
            case "14": {
                RideType rideType22;
                rideType2 = rideType22 = "80X".equals(route.getShortName()) ? RideType.WHATCOM_CROSS_COUNTY : RideType.WHATCOM_LOCAL;
                return rideType2;
            }
        }
        rideType2 = rideType = RideType.UNKNOWN;
        return rideType2;
    }

    public OrcaFareService(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.addFareRules(FareType.senior, regularFareRules);
        this.addFareRules(FareType.youth, regularFareRules);
        this.addFareRules(FareType.electronicRegular, regularFareRules);
        this.addFareRules(FareType.electronicYouth, regularFareRules);
        this.addFareRules(FareType.electronicSpecial, regularFareRules);
        this.addFareRules(FareType.electronicSenior, regularFareRules);
    }

    private Optional<Money> getLegFare(FareType fareType, RideType rideType, Optional<Money> defaultFare, Leg leg) {
        if (rideType == null) {
            return defaultFare;
        }
        if (OrcaFareService.usesOrca(fareType) && !rideType.agencyAcceptsOrca()) {
            return Optional.empty();
        }
        return switch (fareType) {
            case FareType.youth, FareType.electronicYouth -> Optional.of(this.getYouthFare());
            case FareType.electronicSpecial -> this.getLiftFare(rideType, defaultFare, leg);
            case FareType.electronicSenior, FareType.senior -> this.getSeniorFare(fareType, rideType, defaultFare, leg);
            case FareType.regular, FareType.electronicRegular -> this.getRegularFare(fareType, rideType, defaultFare, leg);
            default -> defaultFare;
        };
    }

    private static Optional<Money> optionalUSD(float amount) {
        return Optional.of(Money.usDollars(amount));
    }

    private static Optional<Money> getCTLocalReducedFare(Leg leg) {
        return OrcaFareService.optionalUSD(1.0f);
    }

    private Optional<Money> getRegularFare(FareType fareType, RideType rideType, Optional<Money> defaultFare, Leg leg) {
        Route route = leg.route();
        if (route == null) {
            return defaultFare;
        }
        return switch (rideType.ordinal()) {
            case 2 -> {
                if (OrcaFareService.usesOrca(fareType)) {
                    yield OrcaFareService.optionalUSD(6.0f);
                }
                yield OrcaFareService.optionalUSD(7.0f);
            }
            case 3 -> {
                if (OrcaFareService.usesOrca(fareType)) {
                    yield OrcaFareService.optionalUSD(5.25f);
                }
                yield OrcaFareService.optionalUSD(6.25f);
            }
            case 6 -> OrcaFareService.optionalUSD(2.0f);
            case 7 -> {
                if (leg.startTime().isBefore(KITSAP_FAST_FERRY_CHANGE_DATE.atStartOfDay(leg.startTime().getZone()))) {
                    yield OrcaFareService.optionalUSD(12.0f);
                }
                yield OrcaFareService.optionalUSD(13.0f);
            }
            case 16 -> defaultFare.map(df -> this.getWashingtonStateFerriesFare(route.getLongName(), fareType, (Money)df));
            case 12 -> OrcaFareService.optionalUSD(3.25f);
            case 17, 18, 19, 20 -> {
                if (fareType.equals(FareType.electronicRegular)) {
                    yield Optional.empty();
                }
                yield defaultFare;
            }
            default -> defaultFare;
        };
    }

    private Optional<Money> getLiftFare(RideType rideType, Optional<Money> defaultFare, Leg leg) {
        Route route = leg.route();
        if (route == null) {
            return defaultFare;
        }
        return switch (rideType.ordinal()) {
            case 0 -> OrcaFareService.getCTLocalReducedFare(leg);
            case 2, 3 -> OrcaFareService.optionalUSD(1.0f);
            case 1, 4, 5, 8, 10, 11, 12, 13, 14, 15 -> OrcaFareService.optionalUSD(1.0f);
            case 16 -> defaultFare.map(df -> this.getWashingtonStateFerriesFare(route.getLongName(), FareType.electronicSpecial, (Money)df));
            case 6 -> OrcaFareService.optionalUSD(1.0f);
            case 7 -> {
                if (leg.startTime().isBefore(KITSAP_FAST_FERRY_CHANGE_DATE.atStartOfDay(leg.startTime().getZone()))) {
                    yield OrcaFareService.optionalUSD(6.0f);
                }
                yield OrcaFareService.optionalUSD(6.5f);
            }
            case 17, 18, 19, 20 -> Optional.empty();
            default -> defaultFare;
        };
    }

    private Optional<Money> getSeniorFare(FareType fareType, RideType rideType, Optional<Money> defaultFare, Leg leg) {
        Route route = leg.route();
        if (route == null) {
            return defaultFare;
        }
        return switch (rideType.ordinal()) {
            case 0 -> OrcaFareService.getCTLocalReducedFare(leg);
            case 9, 17, 19 -> OrcaFareService.optionalUSD(0.5f);
            case 1 -> OrcaFareService.optionalUSD(0.5f);
            case 4, 5, 6, 8, 10, 11, 12, 13, 14, 15 -> OrcaFareService.optionalUSD(1.0f);
            case 2 -> OrcaFareService.optionalUSD(3.0f);
            case 3 -> OrcaFareService.optionalUSD(2.5f);
            case 7 -> {
                if (leg.startTime().isBefore(KITSAP_FAST_FERRY_CHANGE_DATE.atStartOfDay(leg.startTime().getZone()))) {
                    yield OrcaFareService.optionalUSD(6.0f);
                }
                yield OrcaFareService.optionalUSD(6.5f);
            }
            case 16 -> defaultFare.map(df -> this.getWashingtonStateFerriesFare(route.getLongName(), fareType, (Money)df));
            case 18, 20 -> defaultFare.map(Money::half);
            default -> defaultFare;
        };
    }

    private Money getYouthFare() {
        return Money.ZERO_USD;
    }

    private Money getWashingtonStateFerriesFare(I18NString routeLongName, FareType fareType, Money defaultFare) {
        if (routeLongName == null || routeLongName.toString().isEmpty()) {
            return defaultFare;
        }
        return switch (fareType) {
            default -> throw new MatchException(null, null);
            case FareType.youth, FareType.electronicYouth -> Money.ZERO_USD;
            case FareType.electronicSpecial, FareType.regular, FareType.electronicRegular -> defaultFare;
            case FareType.electronicSenior, FareType.senior -> defaultFare.half().roundDownToNearestFiveMinorUnits();
        };
    }

    protected Optional<Money> getRidePrice(Leg leg, FareType fareType, Collection<FareRuleSet> fareRules) {
        return this.calculateCost(fareType, Lists.newArrayList((Object[])new Leg[]{leg}), fareRules);
    }

    @Override
    public ItineraryFare calculateFaresForType(Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        ItineraryFare fare = ItineraryFare.empty();
        ArrayList<ExtendedFareOffer> purchasedFareProducts = new ArrayList<ExtendedFareOffer>();
        for (Leg leg : legs) {
            Optional<Money> singleLegPrice;
            RideType rideType = OrcaFareService.getRideType(leg);
            Optional<Money> optionalLegFare = this.getLegFare(fareType, rideType, singleLegPrice = this.getRidePrice(leg, FareType.regular, fareRules), leg);
            if (optionalLegFare.isEmpty()) continue;
            Money legFare = optionalLegFare.get();
            if (legFare.equals(Money.ZERO_USD)) {
                RiderCategory riderCategory = OrcaFareService.getRiderCategory(fareType);
                FareProduct zeroFareProduct = FareProduct.of(new FeedScopedId(FEED_ID, "freeFare"), "Free Fare", Money.ZERO_USD).withCategory(riderCategory).withMedium(OrcaFareService.usesOrca(fareType) ? ELECTRONIC_MEDIUM : CASH_MEDIUM).build();
                FareOffer zeroFareOffer = FareOffer.of(leg.startTime(), zeroFareProduct);
                fare.addFareProduct(leg, zeroFareOffer);
                continue;
            }
            List<ExtendedFareOffer> validFareProducts = purchasedFareProducts.stream().filter(fp -> fp.isValidAt(leg.startTime())).toList();
            TransferType transferType = rideType.getTransferType(fareType, leg.startTime());
            if (transferType == TransferType.ORCA_INTERAGENCY_TRANSFER) {
                Money totalAlreadyPurchased = validFareProducts.stream().reduce(Money.ZERO_USD, (subtotal, el) -> subtotal.plus(el.fareOffer.fareProduct().price()), Money::plus);
                Money additionalFareRequired = legFare.minus(totalAlreadyPurchased);
                RiderCategory riderCategory = OrcaFareService.getRiderCategory(fareType);
                FareProduct newFareProduct = FareProduct.of(new FeedScopedId(FEED_ID, "orcaFare"), "ORCA Fare", additionalFareRequired.isPositive() ? additionalFareRequired : Money.ZERO_USD).withValidity(Duration.ofHours(2L)).withCategory(riderCategory).withMedium(ELECTRONIC_MEDIUM).build();
                if (additionalFareRequired.isPositive()) {
                    validFareProducts.forEach(vfp -> {
                        vfp.extendedStartTime = leg.startTime();
                    });
                }
                List<FareProduct> dependencies = validFareProducts.stream().map(ExtendedFareOffer::fareOffer).map(FareOffer::fareProduct).toList();
                FareOffer newFareOffer = FareOffer.of(leg.startTime(), newFareProduct, dependencies);
                fare.addFareProduct(leg, newFareOffer);
                purchasedFareProducts.add(new ExtendedFareOffer(newFareOffer, leg.startTime()));
                continue;
            }
            if (transferType == TransferType.SAME_AGENCY_TRANSFER) {
                String mediumId = "cash";
                FareMedium agencyTransferMedium = new FareMedium(new FeedScopedId(FEED_ID, mediumId), mediumId);
                List<FareOffer> validAgencyFareProducts = validFareProducts.stream().map(ExtendedFareOffer::fareOffer).filter(fp -> fp.fareProduct().medium().equals(agencyTransferMedium)).toList();
                boolean hasValidTransfer = !validAgencyFareProducts.isEmpty();
                if (hasValidTransfer) continue;
                RiderCategory riderCategory = OrcaFareService.getRiderCategory(fareType);
                FareProduct newFareProduct = FareProduct.of(new FeedScopedId(FEED_ID, mediumId), String.format("%s Cash Transfer", leg.agency().getName()), legFare).withCategory(riderCategory).withMedium(agencyTransferMedium).build();
                FareOffer newFareOffer = FareOffer.of(leg.startTime(), newFareProduct);
                fare.addFareProduct(leg, newFareOffer);
                purchasedFareProducts.add(new ExtendedFareOffer(newFareOffer, leg.startTime()));
                continue;
            }
            RiderCategory riderCategory = OrcaFareService.getRiderCategory(fareType);
            FareProduct genericFareProduct = FareProduct.of(new FeedScopedId(FEED_ID, String.format("%sFare", leg.agency().getName())), String.format("%s Fare", leg.agency().getName()), legFare).withCategory(riderCategory).withMedium(OrcaFareService.usesOrca(fareType) ? ELECTRONIC_MEDIUM : CASH_MEDIUM).build();
            FareOffer genericFareOffer = FareOffer.of(leg.startTime(), genericFareProduct);
            fare.addFareProduct(leg, genericFareOffer);
        }
        return fare;
    }

    @Override
    @Nullable
    protected Collection<FareRuleSet> fareRulesForFeed(FareType fareType, String feedId) {
        return (Collection)this.fareRulesPerType.get(fareType);
    }

    @Override
    protected Map<String, List<Leg>> fareLegsByFeed(List<Leg> fareLegs) {
        return Map.of(FEED_ID, fareLegs);
    }

    private static boolean inFreeTransferWindow(ZonedDateTime freeTransferStartTime, ZonedDateTime currentLegStartTime) {
        if (freeTransferStartTime == null) {
            return false;
        }
        Duration duration = Duration.between(freeTransferStartTime, currentLegStartTime);
        return duration.compareTo(MAX_TRANSFER_DISCOUNT_DURATION) < 0;
    }

    private static boolean usesOrca(FareType fareType) {
        return fareType.equals(FareType.electronicSpecial) || fareType.equals(FareType.electronicSenior) || fareType.equals(FareType.electronicRegular) || fareType.equals(FareType.electronicYouth);
    }

    private static RiderCategory getRiderCategory(FareType fareType) {
        String[] splitFareType = fareType.toString().split("electronic");
        String name = splitFareType.length > 1 ? splitFareType[1].toLowerCase() : fareType.toString();
        return new RiderCategory(new FeedScopedId(FEED_ID, name), name, null);
    }

    protected static enum RideType {
        COMM_TRANS_LOCAL_SWIFT,
        EVERETT_TRANSIT,
        KC_WATER_TAXI_VASHON_ISLAND,
        KC_WATER_TAXI_WEST_SEATTLE,
        KC_METRO,
        KITSAP_TRANSIT,
        KITSAP_TRANSIT_FAST_FERRY_EASTBOUND,
        KITSAP_TRANSIT_FAST_FERRY_WESTBOUND,
        PIERCE_COUNTY_TRANSIT,
        SKAGIT_TRANSIT,
        SEATTLE_STREET_CAR,
        SOUND_TRANSIT,
        SOUND_TRANSIT_BUS,
        SOUND_TRANSIT_SOUNDER,
        SOUND_TRANSIT_T_LINK,
        SOUND_TRANSIT_LINK,
        WASHINGTON_STATE_FERRIES,
        WHATCOM_LOCAL,
        WHATCOM_CROSS_COUNTY,
        SKAGIT_LOCAL,
        SKAGIT_CROSS_COUNTY,
        UNKNOWN;


        public TransferType getTransferType(FareType fareType, ZonedDateTime startTime) {
            if (OrcaFareService.usesOrca(fareType) && this.permitsFreeTransfers(startTime)) {
                return TransferType.ORCA_INTERAGENCY_TRANSFER;
            }
            if (this == KC_METRO || this == KITSAP_TRANSIT) {
                return TransferType.SAME_AGENCY_TRANSFER;
            }
            return TransferType.NO_TRANSFER;
        }

        public boolean permitsFreeTransfers(ZonedDateTime startTime) {
            return switch (this.ordinal()) {
                case 9, 16, 17, 18, 20 -> false;
                case 6, 7 -> {
                    if (!startTime.isAfter(KITSAP_FAST_FERRY_CHANGE_DATE.atStartOfDay(startTime.getZone()))) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }

        public boolean agencyAcceptsOrca() {
            return switch (this.ordinal()) {
                case 17, 18, 19, 20 -> false;
                default -> true;
            };
        }
    }

    protected static enum TransferType {
        ORCA_INTERAGENCY_TRANSFER,
        KCM_PAPER_TRANSFER,
        KT_PAPER_TRANSFER,
        SAME_AGENCY_TRANSFER,
        NO_TRANSFER;

    }

    private static class ExtendedFareOffer {
        public ZonedDateTime extendedStartTime;
        public FareOffer fareOffer;

        public ExtendedFareOffer(FareOffer fareOffer, ZonedDateTime extendedStartTime) {
            this.extendedStartTime = extendedStartTime;
            this.fareOffer = fareOffer;
        }

        public FareOffer fareOffer() {
            return this.fareOffer;
        }

        public boolean isValidAt(ZonedDateTime checkTime) {
            return this.extendedStartTime.plus(MAX_TRANSFER_DISCOUNT_DURATION).isAfter(checkTime);
        }
    }

    static class TransferData {
        private Money transferDiscount;
        private ZonedDateTime transferStartTime;

        TransferData() {
        }

        public Money getTransferDiscount() {
            if (this.transferDiscount == null) {
                return Money.ZERO_USD;
            }
            return this.transferDiscount;
        }

        public Money getDiscountedLegPrice(Leg leg, Money legPrice) {
            boolean inFreeTransferWindow;
            if (this.transferStartTime != null && (inFreeTransferWindow = OrcaFareService.inFreeTransferWindow(this.transferStartTime, leg.startTime()))) {
                if (legPrice.greaterThan(this.transferDiscount)) {
                    this.transferStartTime = leg.startTime();
                    Money discountedLegFare = legPrice.minus(this.transferDiscount);
                    this.transferDiscount = legPrice;
                    return discountedLegFare;
                }
                return Money.ZERO_USD;
            }
            this.transferDiscount = legPrice;
            this.transferStartTime = leg.startTime();
            return legPrice;
        }
    }
}

