/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class HighestFareInFreeTransferWindowFareService
extends DefaultFareService {
    private final boolean analyzeInterlinedTransfers;
    private final Duration freeTransferWindow;

    public HighestFareInFreeTransferWindowFareService(Collection<FareRuleSet> regularFareRules, Duration freeTransferWindow, boolean analyzeInterlinedTransfers) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.freeTransferWindow = freeTransferWindow;
        this.analyzeInterlinedTransfers = analyzeInterlinedTransfers;
    }

    public boolean analyzeInterlinedTransfers() {
        return this.analyzeInterlinedTransfers;
    }

    public Duration freeTransferWindow() {
        return this.freeTransferWindow;
    }

    @Override
    protected ItineraryFare calculateFaresForType(Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        Money zero;
        Money cost = zero = Money.ofFractionalAmount(currency, 0.0f);
        Money currentTransferWindowCost = zero;
        long freeTransferWindowEndTimeEpochSeconds = -1L;
        for (Leg leg : legs) {
            Optional<Money> rideCost = this.calculateCost(fareType, List.of(leg), fareRules);
            if (leg.startTime().toEpochSecond() > freeTransferWindowEndTimeEpochSeconds) {
                cost = cost.plus(currentTransferWindowCost);
                currentTransferWindowCost = zero;
                freeTransferWindowEndTimeEpochSeconds = -1L;
            }
            if (freeTransferWindowEndTimeEpochSeconds == -1L) {
                freeTransferWindowEndTimeEpochSeconds = leg.startTime().plus(this.freeTransferWindow).toEpochSecond();
            }
            currentTransferWindowCost = Money.max(currentTransferWindowCost, rideCost.orElse(zero));
        }
        cost = cost.plus(currentTransferWindowCost);
        FareProduct fp = FareProduct.of(new FeedScopedId("fares", fareType.name()), fareType.name(), cost).build();
        ItineraryFare fare = ItineraryFare.empty();
        if (cost.greaterThan(zero)) {
            fare.addItineraryProducts(List.of(fp));
        }
        return fare;
    }

    @Override
    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg current, ScheduledTransitLeg previous) {
        return !this.analyzeInterlinedTransfers;
    }
}

