/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.impl.gtfs.FareAndId;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.fares.model.RouteOriginDestination;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.transit.model.basic.Money;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSLFareService
extends DefaultFareService {
    private static final Logger LOG = LoggerFactory.getLogger(HSLFareService.class);
    public static final Money MAX_PRICE = Money.euros(999999.0f);

    @Override
    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg previousLeg, ScheduledTransitLeg currentLeg) {
        return true;
    }

    @Override
    protected Optional<FareAndId> getBestFareAndId(FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        ZonedDateTime startTime;
        HashSet<String> zones = new HashSet<String>();
        ZonedDateTime lastRideStartTime = startTime = legs.get(0).startTime();
        Money specialRouteFare = MAX_PRICE;
        FareAttribute specialFareAttribute = null;
        String agency = null;
        boolean singleAgency = true;
        Set fareRuleFeedIds = fareRules.stream().map(fr -> fr.getFareAttribute().getId().getFeedId()).collect(Collectors.toSet());
        Set legFeedIds = legs.stream().map(leg -> leg.agency().getId().getFeedId()).collect(Collectors.toSet());
        if (!Sets.difference(legFeedIds, fareRuleFeedIds).isEmpty()) {
            return Optional.empty();
        }
        for (Leg leg2 : legs) {
            lastRideStartTime = leg2.startTime();
            if (agency == null) {
                agency = leg2.agency().getId().getId().toString();
            } else if (agency != leg2.agency().getId().getId().toString()) {
                singleAgency = false;
            }
            Money bestSpecialFare = MAX_PRICE;
            Set<String> ruleZones = null;
            for (FareRuleSet ruleSet : fareRules) {
                Money newFare;
                FareAttribute attribute2;
                if (ruleSet.hasAgencyDefined() && leg2.agency().getId().getId() != ruleSet.getAgency().getId()) continue;
                RouteOriginDestination routeOriginDestination = new RouteOriginDestination(leg2.route().getId().toString(), leg2.from().stop.getFirstZoneAsString(), leg2.to().stop.getFirstZoneAsString());
                boolean isSpecialRoute = false;
                if (!ruleSet.getRouteOriginDestinations().isEmpty() && ruleSet.getRouteOriginDestinations().toString().indexOf(routeOriginDestination.toString()) != -1) {
                    isSpecialRoute = true;
                }
                if (!isSpecialRoute && (!ruleSet.getRoutes().contains(leg2.route().getId()) || !ruleSet.getContains().contains(leg2.from().stop.getFirstZoneAsString()) || !ruleSet.getContains().contains(leg2.to().stop.getFirstZoneAsString())) || (attribute2 = ruleSet.getFareAttribute()).isTransferDurationSet() && Duration.between(lastRideStartTime, startTime).getSeconds() >= (long)attribute2.getTransferDuration().intValue() || !(newFare = attribute2.getPrice()).lessThan(bestSpecialFare)) continue;
                bestSpecialFare = newFare;
                ruleZones = ruleSet.getContains();
                if (!isSpecialRoute) continue;
                specialRouteFare = bestSpecialFare;
                specialFareAttribute = attribute2;
            }
            if (ruleZones != null) {
                HashSet<String> zoneIntersection = new HashSet<String>(leg2.fareZones().stream().map(z -> z.getId().getId()).toList());
                zoneIntersection.retainAll(ruleZones);
                zones.addAll(zoneIntersection);
                continue;
            }
            zones.addAll(leg2.fareZones().stream().map(z -> z.getId().getId()).toList());
        }
        FareAttribute bestAttribute = null;
        Money bestFare = MAX_PRICE;
        long tripTime = Duration.between(startTime, lastRideStartTime).getSeconds();
        if (zones.size() > 0) {
            for (FareRuleSet ruleSet : fareRules) {
                Money newFare;
                if (ruleSet.hasAgencyDefined() && (!singleAgency || agency != ruleSet.getAgency().getId()) || !ruleSet.getContains().containsAll(zones)) continue;
                FareAttribute attribute3 = ruleSet.getFareAttribute();
                if (attribute3.isTransferDurationSet()) {
                    if (tripTime > (long)attribute3.getTransferDuration().intValue()) {
                        LOG.debug("transfer time exceeded; {} > {} in fare {}", new Object[]{tripTime, attribute3.getTransferDuration(), attribute3.getId()});
                        continue;
                    }
                    LOG.debug("transfer time OK; {} < {} in fare {}", new Object[]{tripTime, attribute3.getTransferDuration(), attribute3.getId()});
                }
                if (!(newFare = attribute3.getPrice()).lessThan(bestFare) && (!newFare.equals(bestFare) || !ruleSet.getContains().equals(zones))) continue;
                bestAttribute = attribute3;
                bestFare = newFare;
            }
        } else if (!specialRouteFare.equals(MAX_PRICE) && specialFareAttribute != null) {
            bestFare = specialRouteFare;
            bestAttribute = specialFareAttribute;
        }
        LOG.debug("HSL {} best for {}", bestAttribute, legs);
        Money finalBestFare = bestFare;
        return Optional.ofNullable(bestAttribute).map(attribute -> new FareAndId(finalBestFare, attribute.getId()));
    }
}

