/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;

public class AtlantaFareService
extends DefaultFareService {
    private static final ZoneId NEW_YORK_ZONE_ID = ZoneId.of("America/New_York");
    public static final String COBB_AGENCY_ID = "2";
    public static final String XPRESS_AGENCY_ID = "6";
    public static final String MARTA_AGENCY_ID = "5";
    public static final String GCT_AGENCY_ID = "4";
    public static final Set<String> COBB_FREE_RIDE_SHORT_NAMES = Set.of("blue", "green");
    private static final String FEED_ID = "atlanta";

    protected Money getLegPrice(Leg leg, FareType fareType, Collection<FareRuleSet> fareRules) {
        return this.calculateCost(fareType, Lists.newArrayList((Object[])new Leg[]{leg}), fareRules).orElse(Money.ZERO_USD);
    }

    private static RideType classify(Leg ride) {
        Route getRoute = ride.route();
        String shortName = getRoute.getShortName();
        if (shortName != null) {
            shortName = shortName.toLowerCase();
        }
        switch (getRoute.getAgency().getId().getId()) {
            case "2": {
                if (RideType.COBB_EXPRESS.routeNamesContains(shortName)) {
                    return RideType.COBB_EXPRESS;
                }
                if (COBB_FREE_RIDE_SHORT_NAMES.contains(shortName)) {
                    return RideType.FREE_RIDE;
                }
                return RideType.COBB_LOCAL;
            }
            case "6": {
                long hours = ride.startTime().withZoneSameInstant(NEW_YORK_ZONE_ID).getHour();
                if (hours >= 12L) {
                    return RideType.XPRESS_AFTERNOON;
                }
                return RideType.XPRESS_MORNING;
            }
            case "4": {
                if (RideType.GCT_EXPRESS_Z1.routeNamesContains(shortName)) {
                    return RideType.GCT_EXPRESS_Z1;
                }
                if (RideType.GCT_EXPRESS_Z2.routeNamesContains(shortName)) {
                    return RideType.GCT_EXPRESS_Z2;
                }
                return RideType.GCT_LOCAL;
            }
        }
        if (RideType.STREETCAR.routeNamesContains(shortName)) {
            return RideType.STREETCAR;
        }
        return RideType.MARTA;
    }

    private static int getMaxTransfers(RideType rideType) {
        return switch (rideType.ordinal()) {
            case 4, 5, 6 -> 3;
            default -> 4;
        };
    }

    private static Duration getTransferWindow(RideType ignored) {
        return Duration.ofHours(3L);
    }

    private static TransferMeta classifyTransfer(RideType toRideType, RideType fromRideType, FareType fareType) {
        switch (toRideType.ordinal()) {
            case 0: 
            case 9: {
                return new TransferMeta(TransferType.NO_TRANSFER);
            }
            case 2: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    if (fromRideType == RideType.COBB_LOCAL || fromRideType == RideType.COBB_EXPRESS) {
                        return new TransferMeta(TransferType.FREE_TRANSFER);
                    }
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType.ordinal()) {
                    case 1, 2, 3 -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case 3: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return switch (fromRideType.ordinal()) {
                        case 3 -> new TransferMeta(TransferType.FREE_TRANSFER);
                        case 2 -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                        default -> new TransferMeta(TransferType.END_TRANSFER);
                    };
                }
                return switch (fromRideType.ordinal()) {
                    case 1, 3 -> new TransferMeta(TransferType.FREE_TRANSFER);
                    case 2 -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                    default -> new TransferMeta(TransferType.NO_TRANSFER);
                };
            }
            case 1: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType.ordinal()) {
                    case 1, 2, 3, 4, 5, 6, 7, 8 -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case 7: 
            case 8: {
                boolean payOnExit;
                boolean bl = payOnExit = toRideType == RideType.XPRESS_AFTERNOON;
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType.ordinal()) {
                    case 1, 3, 5, 6, 7, 8 -> new TransferMeta(TransferType.FREE_TRANSFER, Money.ZERO_USD, payOnExit);
                    case 2 -> new TransferMeta(TransferType.TRANSFER_WITH_UPCHARGE, Money.usDollars(1.5f), payOnExit);
                    case 4 -> new TransferMeta(TransferType.TRANSFER_WITH_UPCHARGE, Money.usDollars(1.0f), payOnExit);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case 4: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType.ordinal()) {
                    case 1, 4, 5, 6 -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case 5: 
            case 6: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType.ordinal()) {
                    case 1 -> new TransferMeta(TransferType.FREE_TRANSFER);
                    case 4, 5, 6 -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
        }
        return new TransferMeta(TransferType.END_TRANSFER);
    }

    private static boolean isElectronicPayment(FareType fareType) {
        return fareType.equals(FareType.electronicRegular) || fareType.equals(FareType.electronicSenior) || fareType.equals(FareType.electronicSpecial) || fareType.equals(FareType.electronicYouth);
    }

    public AtlantaFareService(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.addFareRules(FareType.senior, regularFareRules);
        this.addFareRules(FareType.youth, regularFareRules);
        this.addFareRules(FareType.electronicRegular, regularFareRules);
        this.addFareRules(FareType.electronicYouth, regularFareRules);
        this.addFareRules(FareType.electronicSpecial, regularFareRules);
        this.addFareRules(FareType.electronicSenior, regularFareRules);
    }

    @Override
    @Nullable
    protected Collection<FareRuleSet> fareRulesForFeed(FareType fareType, String feedId) {
        return (Collection)this.fareRulesPerType.get(fareType);
    }

    @Override
    public ItineraryFare calculateFaresForType(Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        ArrayList<ATLTransfer> transfers = new ArrayList<ATLTransfer>();
        for (Leg leg : legs) {
            ATLTransfer latestTransfer;
            Money defaultFare = this.getLegPrice(leg, fareType, fareRules);
            if (transfers.isEmpty()) {
                transfers.add(new ATLTransfer(currency, fareType));
            }
            if ((latestTransfer = (ATLTransfer)transfers.get(transfers.size() - 1)).addLeg(leg, defaultFare)) continue;
            ATLTransfer newXfer = new ATLTransfer(currency, fareType);
            newXfer.addLeg(leg, defaultFare);
            transfers.add(newXfer);
        }
        Money cost = Money.ZERO_USD;
        for (ATLTransfer transfer : transfers) {
            cost = cost.plus(transfer.getTotal());
        }
        FareProduct fareProduct = FareProduct.of(new FeedScopedId(FEED_ID, fareType.name()), fareType.name(), cost).build();
        ItineraryFare fare = ItineraryFare.empty();
        fare.addItineraryProducts(List.of(fareProduct));
        return fare;
    }

    private static enum RideType {
        FREE_RIDE(new String[0]),
        MARTA(new String[0]),
        COBB_LOCAL(new String[0]),
        COBB_EXPRESS("100", "101", "102"),
        GCT_LOCAL(new String[0]),
        GCT_EXPRESS_Z1("102", "103a", "110", "swpr"),
        GCT_EXPRESS_Z2("101", "103"),
        XPRESS_MORNING(new String[0]),
        XPRESS_AFTERNOON(new String[0]),
        STREETCAR("atlsc");

        private final Set<String> routeNames;

        private RideType(String ... members) {
            this.routeNames = Arrays.stream(members).map(String::toLowerCase).collect(Collectors.toSet());
        }

        public boolean routeNamesContains(@Nullable String s) {
            if (s == null) {
                return false;
            }
            return this.routeNames.contains(s.toLowerCase());
        }
    }

    private static class TransferMeta {
        public final TransferType type;
        public final Money upcharge;
        public final boolean payOnExit;

        public TransferMeta(TransferType type, Money upcharge, boolean payOnExit) {
            this.type = type;
            this.upcharge = upcharge;
            this.payOnExit = payOnExit;
        }

        public TransferMeta(TransferType type) {
            this(type, Money.ZERO_USD, false);
        }
    }

    private static enum TransferType {
        END_TRANSFER,
        NO_TRANSFER,
        FREE_TRANSFER,
        TRANSFER_WITH_UPCHARGE,
        TRANSFER_PAY_DIFFERENCE;

    }

    private static class ATLTransfer {
        List<Leg> legs = new ArrayList<Leg>();
        Multimap<FareType, Money> fares = ArrayListMultimap.create();
        final FareType fareType;
        final Currency currency;
        Money lastFareWithTransfer;
        int maxRides;
        Duration transferWindow;

        public ATLTransfer(Currency currency, FareType fareType) {
            this.fareType = fareType;
            this.currency = currency;
        }

        public boolean addLeg(Leg leg, Money defaultFare) {
            ZonedDateTime transferUseTime;
            RideType toRideType = AtlantaFareService.classify(leg);
            if (this.legs.size() == 0) {
                this.legs.add(leg);
                this.fares.put((Object)this.fareType, (Object)defaultFare);
                this.lastFareWithTransfer = defaultFare;
                this.maxRides = AtlantaFareService.getMaxTransfers(toRideType);
                this.transferWindow = AtlantaFareService.getTransferWindow(toRideType);
                return true;
            }
            Leg latestRide = this.legs.get(this.legs.size() - 1);
            ZonedDateTime transferStartTime = this.legs.get(0).startTime();
            RideType fromRideType = AtlantaFareService.classify(latestRide);
            TransferMeta transferClassification = AtlantaFareService.classifyTransfer(toRideType, fromRideType, this.fareType);
            ZonedDateTime zonedDateTime = transferUseTime = transferClassification.payOnExit ? leg.endTime() : leg.startTime();
            if (!transferClassification.type.equals((Object)TransferType.NO_TRANSFER)) {
                if (transferClassification.type.equals((Object)TransferType.END_TRANSFER)) {
                    return false;
                }
                if (transferUseTime.isAfter(transferStartTime.plus(this.transferWindow))) {
                    return false;
                }
                if (this.legs.size() > this.maxRides) {
                    return false;
                }
            }
            if (transferClassification.type.equals((Object)TransferType.NO_TRANSFER)) {
                this.fares.put((Object)this.fareType, (Object)defaultFare);
                return true;
            }
            this.legs.add(leg);
            if (transferClassification.type.equals((Object)TransferType.FREE_TRANSFER)) {
                this.fares.put((Object)this.fareType, (Object)Money.ofFractionalAmount(this.currency, 0.0f));
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            if (transferClassification.type.equals((Object)TransferType.TRANSFER_PAY_DIFFERENCE)) {
                Money newCost = Money.ZERO_USD;
                if (defaultFare.greaterThan(this.lastFareWithTransfer)) {
                    newCost = defaultFare.minus(this.lastFareWithTransfer);
                }
                this.fares.put((Object)this.fareType, (Object)newCost);
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            if (transferClassification.type.equals((Object)TransferType.TRANSFER_WITH_UPCHARGE)) {
                this.fares.put((Object)this.fareType, (Object)transferClassification.upcharge);
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            return true;
        }

        public Money getTotal() {
            return this.fares.get((Object)this.fareType).stream().reduce(Money.ZERO_USD, Money::plus);
        }
    }
}

