/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.model.fare.FareOffer;
import org.opentripplanner.model.fare.ItineraryFare;
import org.opentripplanner.model.plan.FareProductAware;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.utils.collection.ListUtils;

public final class ItineraryFaresDecorator {
    private final ItineraryFare fare;
    private final List<FareOffer> itineraryFareUses;

    public ItineraryFaresDecorator(ItineraryFare fare, List<FareOffer> itineraryFareUses) {
        this.fare = fare;
        this.itineraryFareUses = itineraryFareUses;
    }

    public static Itinerary decorateItineraryWithFare(Itinerary i, ItineraryFare fare) {
        ItineraryFaresDecorator legDecorator = new ItineraryFaresDecorator(fare, ItineraryFaresDecorator.createItineraryFareUses(i, fare));
        return i.copyOf().withFare(fare).transformTransitLegs(legDecorator::decorateTransitLeg).build();
    }

    private static List<FareOffer> createItineraryFareUses(Itinerary i, ItineraryFare fare) {
        return fare.getItineraryProducts().stream().map(fp -> {
            ZonedDateTime startTime = i.legs().getFirst().startTime();
            return FareOffer.of(startTime, fp);
        }).toList();
    }

    private TransitLeg decorateTransitLeg(TransitLeg leg) {
        TransitLeg transitLeg;
        Collection legUses = this.fare.getLegProducts().get((Object)leg);
        List allUses = ListUtils.combine((Collection[])new Collection[]{this.itineraryFareUses, legUses});
        if (leg instanceof FareProductAware) {
            TransitLeg fpa = leg;
            transitLeg = (TransitLeg)fpa.decorateWithFareOffers(allUses);
        } else {
            transitLeg = leg;
        }
        return transitLeg;
    }
}

