/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares;

import com.fasterxml.jackson.databind.JsonNode;
import org.opentripplanner.ext.fares.impl.AtlantaFareServiceFactory;
import org.opentripplanner.ext.fares.impl.HSLFareServiceFactory;
import org.opentripplanner.ext.fares.impl.HighestFareInFreeTransferWindowFareServiceFactory;
import org.opentripplanner.ext.fares.impl.NoopFareServiceFactory;
import org.opentripplanner.ext.fares.impl.OrcaFareFactory;
import org.opentripplanner.ext.fares.impl.gtfs.CombineInterlinedLegsFactory;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareServiceFactory;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class FaresConfiguration {
    public static JsonNode fromConfig(NodeAdapter root, String parameterName) {
        return root.of(parameterName).summary("Fare configuration.").since(OtpVersion.V2_0).asObject().rawNode();
    }

    public static FareServiceFactory fromConfig(JsonNode config) {
        String type = null;
        if (config == null) {
            type = null;
        } else if (config.isTextual()) {
            type = config.asText();
        } else if (config.has("type")) {
            type = config.path("type").asText(null);
        }
        if (type == null) {
            type = "default";
        }
        FareServiceFactory factory = FaresConfiguration.createFactory(type);
        factory.configure(config);
        return factory;
    }

    private static FareServiceFactory createFactory(String type) {
        return switch (type) {
            case "default" -> new DefaultFareServiceFactory();
            case "off" -> new NoopFareServiceFactory();
            case "highest-fare-in-free-transfer-window", "highestFareInFreeTransferWindow" -> new HighestFareInFreeTransferWindowFareServiceFactory();
            case "hsl" -> new HSLFareServiceFactory();
            case "atlanta" -> new AtlantaFareServiceFactory();
            case "orca" -> new OrcaFareFactory();
            case "combine-interlined-legs" -> new CombineInterlinedLegsFactory();
            default -> throw new IllegalArgumentException(String.format("Unknown fare type: '%s'", type));
        };
    }
}

