/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.parameters;

import org.opentripplanner.framework.model.Gram;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public record EmissionVehicleParameters(Gram avgCo2PerKm, double avgOccupancy) {
    private static final Gram CAR_AVG_CO2_PER_KM = Gram.of(170L);
    private static final double CAR_AVG_OCCUPANCY = 1.3;
    public static final EmissionVehicleParameters CAR_DEFAULTS = new EmissionVehicleParameters(CAR_AVG_CO2_PER_KM, 1.3);

    public EmissionVehicleParameters {
        DoubleUtils.requireInRange((double)avgCo2PerKm.asDouble(), (double)0.0, (double)2000.0, (String)"avgCo2PerKm");
        DoubleUtils.requireInRange((double)avgOccupancy, (double)0.1, (double)20.0, (String)"avgOccupancy");
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(EmissionVehicleParameters.class).addObj("carAvgCo2PerKm", (Object)this.avgCo2PerKm).addNum("carAvgOccupancy", (Number)this.avgOccupancy).toString();
    }
}

