/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.parameters;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.ext.emission.parameters.EmissionFeedParameters;
import org.opentripplanner.ext.emission.parameters.EmissionVehicleParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class EmissionParameters {
    public static final EmissionParameters DEFAULT = new EmissionParameters(EmissionVehicleParameters.CAR_DEFAULTS, List.of());
    private final EmissionVehicleParameters car;
    private final List<EmissionFeedParameters> feeds;

    public EmissionParameters(EmissionVehicleParameters car, List<EmissionFeedParameters> feeds) {
        this.car = car;
        this.feeds = List.copyOf(feeds);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    private Builder copyOf() {
        return new Builder(DEFAULT);
    }

    public EmissionVehicleParameters car() {
        return this.car;
    }

    public List<EmissionFeedParameters> feeds() {
        return this.feeds;
    }

    public List<URI> emissionFiles() {
        return this.feeds.stream().map(f -> f.source()).toList();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmissionParameters that = (EmissionParameters)o;
        return Objects.equals(this.car, that.car) && Objects.equals(this.feeds, that.feeds);
    }

    public int hashCode() {
        return Objects.hash(this.car, this.feeds);
    }

    public String toString() {
        return ToStringBuilder.of(EmissionParameters.class).addObj("car", (Object)this.car, (Object)EmissionVehicleParameters.CAR_DEFAULTS).addCol("fedds", this.feeds).toString();
    }

    public static class Builder {
        private EmissionParameters origin;
        private EmissionVehicleParameters car;
        private List<EmissionFeedParameters> feeds = new ArrayList<EmissionFeedParameters>();

        public Builder(EmissionParameters origin) {
            this.origin = origin;
            this.car = origin.car;
        }

        public Builder addFeeds(Collection<EmissionFeedParameters> feeds) {
            this.feeds.addAll(feeds);
            return this;
        }

        public Builder withCar(EmissionVehicleParameters car) {
            this.car = car;
            return this;
        }

        public EmissionParameters build() {
            EmissionParameters candidate = new EmissionParameters(this.car, this.feeds);
            return this.origin.equals(candidate) ? this.origin : candidate;
        }
    }
}

