/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.itinerary;

import java.util.ArrayList;
import java.util.Optional;
import org.opentripplanner.ext.emission.EmissionService;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.street.search.TraverseMode;

public class EmissionItineraryDecorator
implements ItineraryDecorator {
    private final EmissionService emissionService;

    public EmissionItineraryDecorator(EmissionService emissionService) {
        this.emissionService = emissionService;
    }

    @Override
    public Itinerary decorate(Itinerary itinerary) {
        boolean partialResults = false;
        Emission sum = Emission.ZERO;
        ArrayList<Leg> newLegs = new ArrayList<Leg>();
        for (Leg l : itinerary.legs()) {
            StreetLeg sl;
            Emission value;
            if (l instanceof TransitLeg) {
                TransitLeg tl = (TransitLeg)l;
                value = this.calculateCo2EmissionsForTransit(tl).orElse(null);
            } else if (l instanceof StreetLeg && (sl = (StreetLeg)l).getMode() == TraverseMode.CAR) {
                value = this.calculateCo2EmissionsForCar(sl);
            } else {
                newLegs.add(l);
                continue;
            }
            if (value == null) {
                partialResults = true;
            } else {
                l = l.withEmissionPerPerson(value);
                sum = sum.plus(value);
            }
            newLegs.add(l);
        }
        ItineraryBuilder builder = itinerary.copyOf();
        builder.withLegs(newLegs);
        if (!partialResults) {
            builder.withEmissionPerPerson(sum);
        }
        return builder.build();
    }

    private Optional<Emission> calculateCo2EmissionsForTransit(TransitLeg leg) {
        return this.emissionService.calculateTransitPassengerEmissionForTripHops(leg.trip(), leg.boardStopPosInPattern(), leg.alightStopPosInPattern(), leg.distanceMeters());
    }

    private Emission calculateCo2EmissionsForCar(StreetLeg carLeg) {
        return this.emissionService.calculateCarPassengerEmission(carLeg.distanceMeters());
    }
}

