/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.trip;

import com.csvreader.CsvReader;
import java.util.List;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.AbstractCsvParser;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.EmissionHandledParseException;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopsRow;
import org.opentripplanner.framework.model.Gram;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.utils.lang.DoubleRange;
import org.opentripplanner.utils.lang.IntRange;

class TripHopsCsvParser
extends AbstractCsvParser<TripHopsRow> {
    public static final String TRIP_ID = "trip_id";
    public static final String START_STOP_ID = "from_stop_id";
    public static final String START_STOP_SEQ_NR = "from_stop_sequence";
    private static final String CO2 = "co2";
    private static final List<String> HEADERS = List.of("trip_id", "from_stop_id", "from_stop_sequence", "co2");
    private static final IntRange STOP_SEQ_NR_RANGE = IntRange.ofInclusive((int)0, (int)10000);
    private static final DoubleRange CO2_RANGE = DoubleRange.of((double)-1000000.0, (double)1.0E9);

    public TripHopsCsvParser(DataImportIssueStore issueStore, CsvReader reader) {
        super(issueStore, reader);
    }

    @Override
    protected List<String> headers() {
        return HEADERS;
    }

    @Override
    protected TripHopsRow createNextRow() throws EmissionHandledParseException {
        return new TripHopsRow(this.getString(TRIP_ID), this.getString(START_STOP_ID), this.getInt(START_STOP_SEQ_NR, STOP_SEQ_NR_RANGE), Gram.of(this.getDouble(CO2, CO2_RANGE)));
    }
}

