/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.trip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.ext.emission.internal.csvdata.trip.EmissionAggregator;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopsRow;
import org.opentripplanner.ext.emission.model.TripPatternEmission;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;

public class TripHopMapper {
    private String currentFeedId;
    private Map<FeedScopedId, List<StopLocation>> stopsByTripId;
    private DataImportIssueStore issueStore;

    public TripHopMapper(Map<FeedScopedId, List<StopLocation>> stopsByTripId, DataImportIssueStore issueStore) {
        this.stopsByTripId = stopsByTripId;
        this.issueStore = issueStore;
    }

    public void setCurrentFeedId(String currentFeedId) {
        this.currentFeedId = currentFeedId;
    }

    public Map<FeedScopedId, TripPatternEmission> map(List<TripHopsRow> rows) {
        if (this.currentFeedId == null) {
            throw new IllegalStateException("currentFeedId is not set");
        }
        HashMap<FeedScopedId, EmissionAggregator> builders = new HashMap<FeedScopedId, EmissionAggregator>();
        for (TripHopsRow row : rows) {
            FeedScopedId tripId = new FeedScopedId(this.currentFeedId, row.tripId());
            EmissionAggregator b = builders.computeIfAbsent(tripId, id -> new EmissionAggregator(tripId, this.stopsByTripId.get(tripId)));
            b.mergeEmissionsForHop(row);
        }
        HashMap<FeedScopedId, TripPatternEmission> map = new HashMap<FeedScopedId, TripPatternEmission>();
        for (Map.Entry it : builders.entrySet()) {
            EmissionAggregator builder = (EmissionAggregator)it.getValue();
            Optional<TripPatternEmission> emission = builder.build();
            if (emission.isPresent()) {
                map.put((FeedScopedId)it.getKey(), emission.get());
                continue;
            }
            this.issueStore.addAll(builder.listIssues());
        }
        return map;
    }
}

