/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.trip;

import com.csvreader.CsvReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopsCsvParser;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopsRow;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;

public class TripDataReader {
    private final DataSource emissionDataSource;
    private final DataImportIssueStore issueStore;
    private boolean dataProcessed = false;

    public TripDataReader(DataSource emissionDataSource, DataImportIssueStore issueStore) {
        this.emissionDataSource = emissionDataSource;
        this.issueStore = issueStore;
    }

    public List<TripHopsRow> read(Runnable logStepCallback) {
        if (!this.emissionDataSource.exists()) {
            return List.of();
        }
        ArrayList<TripHopsRow> emissionData = new ArrayList<TripHopsRow>();
        CsvReader reader = new CsvReader(this.emissionDataSource.asInputStream(), StandardCharsets.UTF_8);
        TripHopsCsvParser parser = new TripHopsCsvParser(this.issueStore, reader);
        if (!parser.headersMatch()) {
            return List.of();
        }
        while (parser.hasNext()) {
            logStepCallback.run();
            emissionData.add((TripHopsRow)parser.next());
            this.dataProcessed = true;
        }
        return emissionData;
    }

    public boolean isDataProcessed() {
        return this.dataProcessed;
    }
}

