/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.trip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopsRow;
import org.opentripplanner.ext.emission.model.TripPatternEmission;
import org.opentripplanner.framework.error.OtpError;
import org.opentripplanner.framework.error.WordList;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.lang.IntRange;

class EmissionAggregator {
    private final FeedScopedId tripId;
    private final List<StopLocation> stops;
    private final Emission[] emissions;
    private final int[] counts;
    private final IntRange fromStopSequenceRange;
    private final List<OtpError> errors = new ArrayList<OtpError>();
    private final List<OtpError> warnings = new ArrayList<OtpError>();

    EmissionAggregator(FeedScopedId tripId, @Nullable List<StopLocation> stops) {
        this.tripId = tripId;
        this.stops = stops;
        if (CollectionUtils.isEmpty(this.stops)) {
            this.emissions = null;
            this.counts = null;
            this.fromStopSequenceRange = null;
            this.warnOnMissingStopPatternForTrip();
        } else {
            int size = stops.size() - 1;
            this.fromStopSequenceRange = IntRange.ofInclusive((int)1, (int)size);
            this.emissions = new Emission[size];
            Arrays.fill(this.emissions, Emission.ZERO);
            this.counts = new int[size];
            Arrays.fill(this.counts, 0);
        }
    }

    EmissionAggregator mergeEmissionsForHop(TripHopsRow row) {
        if (this.stops == null) {
            return this;
        }
        if (!this.verifyStop(row)) {
            return this;
        }
        int boardStopPosition = row.boardStopPosInPattern();
        Emission emission = Emission.of(row.co2());
        this.emissions[boardStopPosition] = this.emissions[boardStopPosition].plus(emission);
        this.counts[boardStopPosition] = this.counts[boardStopPosition] + 1;
        return this;
    }

    private boolean verifyStop(TripHopsRow row) {
        if (this.fromStopSequenceRange.isOutside(row.fromStopSequence())) {
            this.addEmissionStopStartSeqNrIssue(row);
            return false;
        }
        StopLocation stop = this.stops.get(row.boardStopPosInPattern());
        if (!stop.getId().getId().equals(row.fromStopId())) {
            this.addEmissionStopIdMismatchIssue(row);
            return false;
        }
        return true;
    }

    Optional<TripPatternEmission> build() {
        if (this.hasErrors()) {
            return Optional.empty();
        }
        new SemanticValidation().verify();
        Emission[] agerageEmissions = new Emission[this.emissions.length];
        for (int i = 0; i < this.emissions.length; ++i) {
            agerageEmissions[i] = this.emissions[i].dividedBy(this.counts[i]);
        }
        return Optional.of(new TripPatternEmission(Arrays.asList(agerageEmissions)));
    }

    List<OtpError> listIssues() {
        return ListUtils.combine((Collection[])new Collection[]{this.errors, this.warnings});
    }

    private boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private void warnOnMissingStopPatternForTrip() {
        this.errors.add(OtpError.of("EmissionMissingTripStopPattern", "No trip with stop pattern found for trip (%s). Trip or stop-pattern is missing. The trip is skipped.", this.tripId));
    }

    private void addEmissionStopStartSeqNrIssue(TripHopsRow row) {
        this.errors.add(OtpError.of("EmissionStopSeqNr", "The emission 'from_stop_sequence' (%d) is out of bounds %s: %s", row.fromStopSequence(), this.fromStopSequenceRange, row.toString()));
    }

    private void addEmissionStopIdMismatchIssue(TripHopsRow row) {
        this.errors.add(OtpError.of("EmissionStopIdMismatch", "Emission 'from_stop_id' (%s) not found in stop pattern for trip (%s): %s", row.fromStopId(), this.tripId, row.toString()));
    }

    class SemanticValidation {
        SemanticValidation() {
        }

        private void verify() {
            this.warnOnMissingHopEmissions();
            this.warnOnDuplicates();
        }

        private void warnOnMissingHopEmissions() {
            WordList missingHops = WordList.of();
            for (int i = 0; i < EmissionAggregator.this.emissions.length; ++i) {
                if (!EmissionAggregator.this.emissions[i].isZero()) continue;
                missingHops.add(Integer.toString(i + 1));
            }
            if (missingHops.isEmpty()) {
                return;
            }
            this.addEmissionMissingHopIssue(missingHops);
        }

        private void addEmissionMissingHopIssue(WordList buf) {
            EmissionAggregator.this.warnings.add(OtpError.of("EmissionMissingTripHop", "Warning! All hops in a trip (%s) should have an emission value. Hop %s does not have an emission value.", EmissionAggregator.this.tripId, buf.toString()));
        }

        private void warnOnDuplicates() {
            if (Arrays.stream(EmissionAggregator.this.counts).anyMatch(i -> i > 1)) {
                EmissionAggregator.this.warnings.add(OtpError.of("EmissionTripHopDuplicates", "Warning! The emission import contains duplicate rows for the same hop for trip (%s). An average value is used.", EmissionAggregator.this.tripId));
            }
        }
    }
}

