/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.route;

import com.csvreader.CsvReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.internal.csvdata.route.RouteCsvParser;
import org.opentripplanner.ext.emission.internal.csvdata.route.RouteRow;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class RouteDataReader {
    private final DataSource emissionDataSource;
    private final DataImportIssueStore issueStore;
    private boolean dataProcessed = false;

    public RouteDataReader(DataSource emissionDataSource, DataImportIssueStore issueStore) {
        this.emissionDataSource = emissionDataSource;
        this.issueStore = issueStore;
    }

    public Map<FeedScopedId, Emission> read(String resolvedFeedId, Runnable logStepCallback) {
        if (!this.emissionDataSource.exists()) {
            return Map.of();
        }
        HashMap<FeedScopedId, Emission> emissionData = new HashMap<FeedScopedId, Emission>();
        CsvReader reader = new CsvReader(this.emissionDataSource.asInputStream(), StandardCharsets.UTF_8);
        RouteCsvParser parser = new RouteCsvParser(this.issueStore, reader);
        if (!parser.headersMatch()) {
            return Map.of();
        }
        while (parser.hasNext()) {
            logStepCallback.run();
            RouteRow value = (RouteRow)parser.next();
            emissionData.put(new FeedScopedId(resolvedFeedId, value.routeId()), Emission.of(value.calculatePassengerCo2PerMeter()));
            this.dataProcessed = true;
        }
        return emissionData;
    }

    public boolean isDataProcessed() {
        return this.dataProcessed;
    }
}

