/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.route;

import com.csvreader.CsvReader;
import java.util.List;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.AbstractCsvParser;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.EmissionHandledParseException;
import org.opentripplanner.ext.emission.internal.csvdata.route.RouteRow;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.utils.lang.DoubleRange;

class RouteCsvParser
extends AbstractCsvParser<RouteRow> {
    private static final String ROUTE_ID = "route_id";
    private static final String AVG_CO_2_PER_VEHICLE_PER_KM = "avg_co2_per_vehicle_per_km";
    private static final String AVG_PASSENGER_COUNT = "avg_passenger_count";
    private static final DoubleRange AVG_CO_2_PER_VEHICLE_PER_KM_RANGE = DoubleRange.of((double)0.0, (double)100000.0);
    private static final DoubleRange AVG_PASSENGER_COUNT_RANGE = DoubleRange.of((double)0.001, (double)10000.0);
    static final List<String> HEADERS = List.of("route_id", "avg_co2_per_vehicle_per_km", "avg_passenger_count");

    public RouteCsvParser(DataImportIssueStore issueStore, CsvReader reader) {
        super(issueStore, reader);
    }

    @Override
    protected List<String> headers() {
        return HEADERS;
    }

    @Override
    protected RouteRow createNextRow() throws EmissionHandledParseException {
        return new RouteRow(this.getString(ROUTE_ID), this.getDouble(AVG_CO_2_PER_VEHICLE_PER_KM, AVG_CO_2_PER_VEHICLE_PER_KM_RANGE), this.getDouble(AVG_PASSENGER_COUNT, AVG_PASSENGER_COUNT_RANGE));
    }
}

