/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata.csvparser;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.EmissionHandledParseException;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.NumberFormatIssue;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.ValueMissingIssue;
import org.opentripplanner.ext.emission.internal.csvdata.csvparser.ValueOutsideRangeIssue;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.utils.lang.DoubleRange;
import org.opentripplanner.utils.lang.IntRange;
import org.opentripplanner.utils.lang.StringUtils;

public abstract class AbstractCsvParser<T> {
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_INT = "int";
    private final DataImportIssueStore issueStore;
    private final CsvReader reader;
    private T next;
    private int lineNumber = 0;

    public AbstractCsvParser(DataImportIssueStore issueStore, CsvReader reader) {
        this.issueStore = issueStore;
        this.reader = reader;
    }

    protected abstract List<String> headers();

    @Nullable
    protected abstract T createNextRow() throws EmissionHandledParseException;

    public boolean headersMatch() {
        try {
            ++this.lineNumber;
            if (!this.reader.readHeaders()) {
                return false;
            }
            List<String> rawHeaders = Arrays.stream(this.reader.getHeaders()).toList();
            return rawHeaders.containsAll(this.headers());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        while (true) {
            try {
                this.next = null;
                if (this.reader.readRecord()) {
                    ++this.lineNumber;
                    this.next = this.createNextRow();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (EmissionHandledParseException emissionHandledParseException) {
                continue;
            }
            break;
        }
    }

    public T next() {
        return this.next;
    }

    protected int getInt(String columnName) throws EmissionHandledParseException {
        return this.getNumber(columnName, TYPE_INT, Integer::parseInt);
    }

    protected int getInt(String columnName, IntRange expectedRange) throws EmissionHandledParseException {
        int value = this.getInt(columnName);
        this.validateInRange(columnName, TYPE_INT, value, arg_0 -> ((IntRange)expectedRange).contains(arg_0), expectedRange);
        return value;
    }

    protected double getDouble(String columnName) throws EmissionHandledParseException {
        return this.getNumber(columnName, TYPE_DOUBLE, Double::parseDouble);
    }

    protected double getDouble(String columnName, DoubleRange expectedRange) throws EmissionHandledParseException {
        double value = this.getDouble(columnName);
        this.validateInRange(columnName, TYPE_DOUBLE, value, arg_0 -> ((DoubleRange)expectedRange).contains(arg_0), expectedRange);
        return value;
    }

    protected String getString(String columnName) throws EmissionHandledParseException {
        try {
            String value = this.reader.get(columnName);
            if (StringUtils.hasNoValue((String)value)) {
                this.issueStore.add(new ValueMissingIssue(columnName, this.line()));
                throw new EmissionHandledParseException();
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        throw new UnsupportedOperationException();
    }

    private <T extends Number> void validateInRange(String columnName, String type, T value, Predicate<T> inRange, Object expectedRange) throws EmissionHandledParseException {
        if (!inRange.test(value)) {
            this.issueStore.add(new ValueOutsideRangeIssue(columnName, value, type, expectedRange, this.line()));
            throw new EmissionHandledParseException();
        }
    }

    private <T> T getNumber(String columnName, String type, Function<String, T> mapper) throws EmissionHandledParseException {
        String value = this.getString(columnName);
        try {
            return mapper.apply(value);
        }
        catch (NumberFormatException e) {
            this.issueStore.add(new NumberFormatIssue(columnName, value, type, this.line()));
            throw new EmissionHandledParseException();
        }
    }

    private String line() {
        return "'" + this.reader.getRawRecord() + "' (@line:" + this.lineNumber + ")";
    }
}

