/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal.csvdata;

import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.internal.csvdata.route.RouteDataReader;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripDataReader;
import org.opentripplanner.ext.emission.internal.csvdata.trip.TripHopMapper;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmissionDataReader {
    private static final Logger LOG = LoggerFactory.getLogger(EmissionDataReader.class);
    public static final String EMISSION_FILE_NAME = "emissions.txt";
    private final DataImportIssueStore issueStore;
    private final EmissionRepository emissionRepository;
    private final TripHopMapper tripHopMapper;

    public EmissionDataReader(EmissionRepository emissionRepository, TripHopMapper tripHopMapper, DataImportIssueStore issueStore) {
        this.tripHopMapper = tripHopMapper;
        this.issueStore = issueStore;
        this.emissionRepository = emissionRepository;
    }

    public void read(CompositeDataSource catalog, String resolvedFeedId) {
        DataSource emissionDataSource = catalog.entry(EMISSION_FILE_NAME);
        if (emissionDataSource == null || !emissionDataSource.exists()) {
            LOG.info("The {} does not contain any {} file.", (Object)catalog.detailedInfo(), (Object)EMISSION_FILE_NAME);
            return;
        }
        this.read(emissionDataSource, resolvedFeedId);
    }

    public void read(DataSource emissionDataSource, String resolvedFeedId) {
        LOG.info("Reading EMISSION data: %s (feedId: %s)".formatted(emissionDataSource.detailedInfo(), resolvedFeedId));
        if (!emissionDataSource.exists()) {
            LOG.info("Emission datasource does not exist! DataSource: {}", (Object)emissionDataSource.detailedInfo());
            return;
        }
        ProgressTracker progress = ProgressTracker.track((String)("Read " + emissionDataSource.name()), (int)10000, (long)-1L);
        RouteDataReader routeReader = new RouteDataReader(emissionDataSource, this.issueStore);
        this.emissionRepository.addRouteEmissions(routeReader.read(resolvedFeedId, () -> EmissionDataReader.logProgress(progress)));
        this.tripHopMapper.setCurrentFeedId(resolvedFeedId);
        TripDataReader tripReader = new TripDataReader(emissionDataSource, this.issueStore);
        this.emissionRepository.addTripPatternEmissions(this.tripHopMapper.map(tripReader.read(() -> EmissionDataReader.logProgress(progress))));
        LOG.info(progress.completeMessage());
        if (!routeReader.isDataProcessed() && !tripReader.isDataProcessed()) {
            LOG.error("No emission data read from: " + emissionDataSource.detailedInfo() + ". Do the header columns match?");
        }
    }

    private static void logProgress(ProgressTracker progress) {
        progress.step(m -> LOG.info(m));
    }
}

