/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.internal;

import jakarta.inject.Inject;
import java.util.Optional;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.EmissionService;
import org.opentripplanner.ext.emission.model.TripPatternEmission;
import org.opentripplanner.model.plan.Emission;
import org.opentripplanner.transit.model.timetable.Trip;

public class DefaultEmissionService
implements EmissionService {
    private final EmissionRepository emissionRepository;

    @Inject
    public DefaultEmissionService(EmissionRepository emissionRepository) {
        this.emissionRepository = emissionRepository;
    }

    @Override
    public Emission calculateCarPassengerEmission(double distance_m) {
        return this.emissionRepository.carAvgPassengerEmissionPerMeter().multiply(distance_m);
    }

    @Override
    public Optional<Emission> calculateTransitPassengerEmissionForTripHops(Trip trip, int boardStopPosInPattern, int alightStopPosInPattern, double distance_m) {
        Optional<Emission> value = this.emissionRepository.routePassengerEmissionsPerMeter(trip.getRoute().getId());
        if (value.isPresent()) {
            return Optional.of(value.get().multiply(distance_m));
        }
        TripPatternEmission emission = this.emissionRepository.tripPatternEmissions(trip.getId());
        if (emission != null) {
            return Optional.of(emission.section(boardStopPosInPattern, alightStopPosInPattern));
        }
        return Optional.empty();
    }
}

