/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.emission.config;

import java.util.List;
import org.opentripplanner.ext.emission.parameters.EmissionFeedParameters;
import org.opentripplanner.ext.emission.parameters.EmissionParameters;
import org.opentripplanner.ext.emission.parameters.EmissionVehicleParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class EmissionConfig {
    public static EmissionParameters mapEmissionsConfig(String parameterName, NodeAdapter root) {
        NodeAdapter c = root.of(parameterName).since(OtpVersion.V2_5).summary("Emissions configuration.").description("By specifying the average CO\u2082 emissions of a car in grams per kilometer as well as\nthe average number of passengers in a car the program is able to to perform emission\ncalculations for car travel.\n").asObject();
        return EmissionParameters.of().addFeeds(EmissionConfig.mapFeeds(c)).withCar(EmissionConfig.mapCar(c)).build();
    }

    private static EmissionVehicleParameters mapCar(NodeAdapter c) {
        return new EmissionVehicleParameters(c.of("carAvgCo2PerKm").since(OtpVersion.V2_5).summary("The average CO\u2082 emissions of a car in grams per kilometer.").asGram(EmissionVehicleParameters.CAR_DEFAULTS.avgCo2PerKm()), c.of("carAvgOccupancy").since(OtpVersion.V2_5).summary("The average number of passengers in a car.").asDouble(EmissionVehicleParameters.CAR_DEFAULTS.avgOccupancy()));
    }

    private static List<EmissionFeedParameters> mapFeeds(NodeAdapter c) {
        return c.of("feeds").since(OtpVersion.V2_8).summary("List of emission feeds.").asObjects(List.of(), EmissionConfig::mapFeed);
    }

    private static EmissionFeedParameters mapFeed(NodeAdapter c) {
        return new EmissionFeedParameters(c.of("feedId").since(OtpVersion.V2_8).summary("Specify the feed id to use for matching transit ids in the emission input data.").asString(), c.of("source").since(OtpVersion.V2_8).summary("Specify the feed source url.").asUri());
    }
}

