/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.debugrastertiles;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.ext.debugrastertiles.DefaultScalarColorPalette;
import org.opentripplanner.ext.debugrastertiles.EdgeVertexTileRenderer;
import org.opentripplanner.ext.debugrastertiles.ScalarColorPalette;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;

public class WalkSafetyEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private final ScalarColorPalette palette = new DefaultScalarColorPalette(1.0, 3.0, 10.0);

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.getPermission().allows(TraverseMode.WALK)) {
                double walkSafety = pse.getWalkSafetyFactor();
                return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(this.palette.getColor(walkSafety), "%.02f".formatted(walkSafety));
            }
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(Color.LIGHT_GRAY, "no walking");
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        if (v instanceof IntersectionVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(Color.DARK_GRAY, null);
        }
        return Optional.empty();
    }
}

