/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.debugrastertiles;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.ext.debugrastertiles.EdgeVertexTileRenderer;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.edge.EscalatorEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmBoardingLocationVertex;
import org.opentripplanner.street.model.vertex.TransitBoardingAreaVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitPathwayNodeVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;

public class TraversalPermissionsEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color LINK_COLOR_EDGE = Color.ORANGE;
    private static final Color ELEVATOR_COLOR_EDGE = Color.YELLOW;
    private static final Color STAIRS_COLOR_EDGE = Color.PINK;
    private static final Color STREET_COLOR_VERTEX = Color.DARK_GRAY;
    private static final Color TRANSIT_STOP_COLOR_VERTEX = new Color(0.0f, 0.0f, 0.8f);
    private static final Color VEHICLE_RENTAL_COLOR_VERTEX = new Color(0.0f, 0.7f, 0.0f);
    private static final Color PARK_AND_RIDE_COLOR_VERTEX = Color.RED;
    private static final Color OSM_BOARDING_LOCATION_VERTEX_COLOR = new Color(23, 160, 234);
    private static final Color BARRIER_COLOR_VERTEX = new Color(0.5803922f, 0.21568628f, 0.24313726f);

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        Object label;
        Color color;
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.isStairs()) {
                color = STAIRS_COLOR_EDGE;
                label = "stairs";
            } else {
                color = this.getColor(pse.getPermission());
                label = this.getLabel(pse.getPermission());
            }
            if (pse.isMotorVehicleNoThruTraffic()) {
                label = (String)label + " car NTT";
            }
            if (pse.isBicycleNoThruTraffic()) {
                label = (String)label + " bike NTT";
            }
            if (pse.isWalkNoThruTraffic()) {
                label = (String)label + " walk NTT";
            }
        } else if (e instanceof ElevatorHopEdge) {
            ElevatorHopEdge ehe = (ElevatorHopEdge)e;
            color = ELEVATOR_COLOR_EDGE;
            label = "elevator";
            if (ehe.isWheelchairAccessible()) {
                label = (String)label + " wheelchair";
            }
            if (ehe.getPermission().allows(StreetTraversalPermission.BICYCLE)) {
                label = (String)label + " bike";
            }
            if (ehe.getPermission().allows(StreetTraversalPermission.CAR)) {
                label = (String)label + " car";
            }
        } else if (e instanceof EscalatorEdge) {
            color = STAIRS_COLOR_EDGE;
            label = "escalator";
        } else {
            color = LINK_COLOR_EDGE;
            label = "link";
        }
        return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(color, (String)label);
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        if (v instanceof OsmBoardingLocationVertex) {
            OsmBoardingLocationVertex osmV = (OsmBoardingLocationVertex)v;
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(OSM_BOARDING_LOCATION_VERTEX_COLOR, "OSM refs" + String.valueOf(osmV.references));
        }
        if (v instanceof IntersectionVertex) {
            if (v instanceof BarrierVertex) {
                return EdgeVertexTileRenderer.VertexVisualAttributes.optional(BARRIER_COLOR_VERTEX, null);
            }
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(STREET_COLOR_VERTEX, null);
        }
        if (v instanceof TransitStopVertex || v instanceof TransitEntranceVertex || v instanceof TransitPathwayNodeVertex || v instanceof TransitBoardingAreaVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(TRANSIT_STOP_COLOR_VERTEX, v.getDefaultName());
        }
        if (v instanceof VehicleRentalPlaceVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(VEHICLE_RENTAL_COLOR_VERTEX, v.getDefaultName());
        }
        if (v instanceof VehicleParkingEntranceVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(PARK_AND_RIDE_COLOR_VERTEX, v.getDefaultName());
        }
        return Optional.empty();
    }

    private Color getColor(StreetTraversalPermission permissions) {
        float r = 0.2f;
        float g = 0.2f;
        float b = 0.2f;
        if (permissions.allows(StreetTraversalPermission.PEDESTRIAN)) {
            g += 0.5f;
        }
        if (permissions.allows(StreetTraversalPermission.BICYCLE)) {
            b += 0.5f;
        }
        if (permissions.allows(StreetTraversalPermission.CAR)) {
            r += 0.5f;
        }
        return new Color(r, g, b);
    }

    private String getLabel(StreetTraversalPermission permissions) {
        StringBuilder sb = new StringBuilder();
        if (permissions.allows(StreetTraversalPermission.PEDESTRIAN)) {
            sb.append("walk,");
        }
        if (permissions.allows(StreetTraversalPermission.BICYCLE)) {
            sb.append("bike,");
        }
        if (permissions.allows(StreetTraversalPermission.CAR)) {
            sb.append("car,");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append("none");
        }
        return sb.toString();
    }
}

