/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.debugrastertiles;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.ext.debugrastertiles.EdgeVertexTileRenderer;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.Vertex;

public class NoThruTrafficEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color[] colors = new Color[]{new Color(200, 200, 200), new Color(200, 200, 0), new Color(0, 200, 200), new Color(0, 200, 0), new Color(0, 0, 200), new Color(200, 100, 0), new Color(200, 0, 200), new Color(200, 0, 0)};

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            int colorIndex = 0;
            Object label = "";
            if (pse.isWalkNoThruTraffic()) {
                label = " walk ";
                ++colorIndex;
            }
            if (pse.isBicycleNoThruTraffic()) {
                label = (String)label + " bike";
                colorIndex += 2;
            }
            if (pse.isMotorVehicleNoThruTraffic()) {
                label = (String)label + " car";
                colorIndex += 4;
            }
            if (!((String)label).isEmpty()) {
                label = "No" + (String)label + " thru traffic";
            }
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(colors[colorIndex], (String)label);
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        return Optional.empty();
    }
}

