/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.debugrastertiles;

import com.jhlabs.awt.ShapeStroke;
import com.jhlabs.awt.TextStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.awt.IdentityPointTransformation;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.linearref.LengthLocationMap;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.opentripplanner.ext.debugrastertiles.TileRenderer;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;

public class EdgeVertexTileRenderer
implements TileRenderer {
    private final EdgeVertexRenderer evRenderer;

    public EdgeVertexTileRenderer(EdgeVertexRenderer evRenderer) {
        this.evRenderer = evRenderer;
    }

    @Override
    public int getColorModel() {
        return 2;
    }

    @Override
    public void renderTile(TileRenderer.TileRenderContext context) {
        float lineWidth = (float)(1.0 + 3.0 / Math.sqrt(context.metersPerPixel));
        Envelope bboxWithMargins = context.expandPixels((double)lineWidth * 2.0, (double)lineWidth * 2.0);
        List<Vertex> vertices = context.graph.findVertices(bboxWithMargins).stream().sorted(this.evRenderer::vertexSorter).toList();
        List<Edge> edges = context.graph.findEdges(bboxWithMargins).stream().distinct().sorted(this.evRenderer::edgeSorter).toList();
        ShapeWriter shapeWriter = new ShapeWriter((PointTransformation)new IdentityPointTransformation(), (PointShapeFactory)new PointShapeFactory.Point());
        BasicStroke stroke = new BasicStroke(lineWidth * 1.4f, 1, 2);
        BasicStroke halfStroke = new BasicStroke(lineWidth * 0.6f + 1.0f, 1, 2);
        BasicStroke halfDashedStroke = new BasicStroke(lineWidth * 0.6f + 1.0f, 0, 2, 1.0f, new float[]{4.0f * lineWidth, lineWidth}, 2.0f * lineWidth);
        ShapeStroke arrowStroke = new ShapeStroke(new Polygon(new int[]{0, 0, 30}, new int[]{0, 20, 10}, 3), lineWidth / 2.0f, 5.0f * lineWidth, 2.5f * lineWidth);
        BasicStroke thinStroke = new BasicStroke(1.0f, 1, 2);
        Font font = new Font("SansSerif", 0, Math.round(lineWidth));
        Font largeFont = new Font("SansSerif", 0, Math.round(lineWidth * 1.5f));
        FontMetrics largeFontMetrics = context.graphics.getFontMetrics(largeFont);
        context.graphics.setFont(largeFont);
        context.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        context.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BufferParameters bufParams = new BufferParameters();
        bufParams.setSingleSided(true);
        bufParams.setJoinStyle(3);
        for (Edge edge : edges) {
            Optional<EdgeVisualAttributes> evAttrsOpt;
            LineString edgeGeom = edge.getGeometry();
            boolean hasGeom = true;
            if (edgeGeom == null) {
                Coordinate[] coordinates = new Coordinate[]{edge.getFromVertex().getCoordinate(), edge.getToVertex().getCoordinate()};
                edgeGeom = GeometryUtils.getGeometryFactory().createLineString(coordinates);
                hasGeom = false;
            }
            if ((evAttrsOpt = this.evRenderer.renderEdge(edge)).isEmpty()) continue;
            EdgeVisualAttributes evAttrs = evAttrsOpt.get();
            OffsetCurveBuilder offsetBuilder = new OffsetCurveBuilder(new PrecisionModel(), bufParams);
            Geometry midLineGeom = context.transform.transform((Geometry)edgeGeom);
            Coordinate[] coords = offsetBuilder.getOffsetCurve(midLineGeom.getCoordinates(), (double)lineWidth * 0.4);
            if (coords.length < 2) continue;
            LineString offsetLine = GeometryUtils.makeLineString(coords);
            Shape midLineShape = shapeWriter.toShape(midLineGeom);
            Shape offsetShape = shapeWriter.toShape((Geometry)offsetLine);
            context.graphics.setStroke(hasGeom ? halfStroke : halfDashedStroke);
            if (this.evRenderer.hasEdgeSegments(edge)) {
                LocationIndexedLine line = new LocationIndexedLine((Geometry)offsetLine);
                LengthLocationMap locater = new LengthLocationMap((Geometry)offsetLine);
                double offsetLength = offsetLine.getLength();
                LinearLocation previousLocation = line.getStartIndex();
                for (EdgeSegmentColor it : this.evRenderer.edgeSegments(edge)) {
                    LinearLocation currentLocation = locater.getLocation(offsetLength * it.position());
                    Geometry segmentGeometry = line.extractLine(previousLocation, currentLocation);
                    Shape segmentShape = shapeWriter.toShape(segmentGeometry);
                    context.graphics.setColor(it.color());
                    context.graphics.draw(segmentShape);
                    previousLocation = currentLocation;
                }
            } else {
                context.graphics.setColor(evAttrs.color);
                context.graphics.draw(offsetShape);
            }
            if (lineWidth > 6.0f) {
                context.graphics.setColor(Color.WHITE);
                context.graphics.setStroke(arrowStroke);
                context.graphics.draw(offsetShape);
            }
            if (lineWidth > 4.0f) {
                context.graphics.setColor(Color.BLACK);
                context.graphics.setStroke(thinStroke);
                context.graphics.draw(midLineShape);
            }
            if (evAttrs.label == null || !(lineWidth > 8.0f)) continue;
            context.graphics.setColor(Color.BLACK);
            context.graphics.setStroke(new TextStroke("    " + evAttrs.label + "                              ", font, false, true));
            context.graphics.draw(offsetShape);
        }
        for (Vertex vertex : vertices) {
            Point point = GeometryUtils.getGeometryFactory().createPoint(vertex.getCoordinate());
            Optional<VertexVisualAttributes> vvAttrsOp = this.evRenderer.renderVertex(vertex);
            if (vvAttrsOp.isEmpty()) continue;
            VertexVisualAttributes vvAttrs = vvAttrsOp.get();
            Point tilePoint = (Point)context.transform.transform((Geometry)point);
            Shape shape = shapeWriter.toShape((Geometry)tilePoint);
            context.graphics.setColor(vvAttrs.color);
            context.graphics.setStroke(stroke);
            context.graphics.draw(shape);
            if (vvAttrs.label == null || !(lineWidth > 6.0f) || !context.bbox.contains(point.getCoordinate())) continue;
            context.graphics.setColor(Color.BLACK);
            int labelWidth = largeFontMetrics.stringWidth(vvAttrs.label);
            double x = tilePoint.getX();
            if (x + (double)labelWidth > (double)context.tileWidth) {
                x -= (double)labelWidth;
            }
            context.graphics.drawString(vvAttrs.label, (float)x, (float)tilePoint.getY());
        }
    }

    public static interface EdgeVertexRenderer {
        public static final Comparator<Vertex> defaultVertexComparator = Comparator.comparing(v -> v instanceof StreetVertex).reversed();
        public static final Comparator<Edge> defaultEdgeComparator = Comparator.comparing(e -> e.getGeometry() != null).thenComparing(e -> e instanceof StreetEdge);

        public Optional<EdgeVisualAttributes> renderEdge(Edge var1);

        public Optional<VertexVisualAttributes> renderVertex(Vertex var1);

        default public boolean hasEdgeSegments(Edge edge) {
            return false;
        }

        default public Iterable<EdgeSegmentColor> edgeSegments(Edge edge) {
            return List.of();
        }

        default public int vertexSorter(Vertex v1, Vertex v2) {
            return defaultVertexComparator.compare(v1, v2);
        }

        default public int edgeSorter(Edge e1, Edge e2) {
            return defaultEdgeComparator.compare(e1, e2);
        }
    }

    public record EdgeVisualAttributes(Color color, String label) {
        public static Optional<EdgeVisualAttributes> optional(Color color, String label) {
            return Optional.of(new EdgeVisualAttributes(color, label));
        }
    }

    record EdgeSegmentColor(Double position, Color color) {
    }

    public record VertexVisualAttributes(Color color, String label) {
        public static Optional<VertexVisualAttributes> optional(Color color, String label) {
            return Optional.of(new VertexVisualAttributes(color, label));
        }
    }
}

