/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.cloud.storage.BlobId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GsHelper {
    private static final Pattern GS_URL_PATTERN = Pattern.compile("//([\\p{Lower}\\d_.-]{3,222})/([^\\p{Cntrl}]+)?");

    private GsHelper() {
    }

    static BlobId toBlobId(URI uri) {
        Matcher m = GS_URL_PATTERN.matcher(uri.getSchemeSpecificPart());
        if (m.matches()) {
            return BlobId.of((String)m.group(1), (String)GsHelper.dirName(m.group(2)));
        }
        throw new IllegalArgumentException("The '" + String.valueOf(uri) + "' is not a legal Google Cloud Storage URL on format: 'gs://bucket-name/object-name'.");
    }

    static String toUriString(BlobId blobId) {
        return GsHelper.toUriString(blobId.getBucket(), blobId.getName());
    }

    static String toUriString(String bucket, String objectName) {
        return "gs://" + bucket + "/" + objectName;
    }

    static URI toUri(String bucket, String objectName) {
        try {
            return new URI(GsHelper.toUriString(bucket, objectName));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
    }

    static boolean isRoot(BlobId blobId) {
        return "".equals(blobId.getName());
    }

    private static String dirName(String objectDir) {
        return objectDir == null ? "" : objectDir;
    }
}

