/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.cloud.storage.BlobId;
import java.net.URI;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.ext.datastore.gs.GsHelper;

abstract class AbstractGsDataSource
implements DataSource {
    private final BlobId blobId;
    private final FileType type;

    AbstractGsDataSource(BlobId blobId, FileType type) {
        this.blobId = blobId;
        this.type = type;
    }

    @Override
    public final String name() {
        return this.blobId.getName();
    }

    @Override
    public final String path() {
        return GsHelper.toUriString(this.blobId);
    }

    @Override
    public URI uri() {
        return URI.create(this.path());
    }

    @Override
    public final FileType type() {
        return this.type;
    }

    public final String toString() {
        return String.valueOf((Object)this.type) + " " + this.path();
    }

    BlobId blobId() {
        return this.blobId;
    }

    String bucketName() {
        return this.blobId.getBucket();
    }
}

