/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParametersBuilder;
import org.opentripplanner.ext.dataoverlay.api.Parameter;
import org.opentripplanner.ext.dataoverlay.api.ParameterName;
import org.opentripplanner.ext.dataoverlay.api.ParameterType;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class DataOverlayParameters
implements Serializable {
    private final Map<Parameter, Double> values;

    public DataOverlayParameters(Map<Parameter, Double> values) {
        this.values = Map.copyOf(values);
    }

    public static DataOverlayParameters parseQueryParams(Map<String, List<String>> params) {
        return DataOverlayParametersBuilder.parseQueryParams(params);
    }

    public static List<String> parametersAsString() {
        ArrayList<String> list = new ArrayList<String>();
        for (ParameterName name : ParameterName.values()) {
            for (ParameterType type : ParameterType.values()) {
                list.add((String.valueOf((Object)name) + "_" + String.valueOf((Object)type)).toLowerCase());
            }
        }
        return list;
    }

    public static String toStringKey(ParameterName name, ParameterType type) {
        return (String.valueOf((Object)name) + "_" + String.valueOf((Object)type)).toLowerCase();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Double get(String param) {
        return this.get(DataOverlayParameters.resolveKey(param));
    }

    public Double get(ParameterName name, ParameterType type) {
        return this.values.get(new Parameter(name, type));
    }

    public Iterable<ParameterName> listParameterNames() {
        return this.values.keySet().stream().map(Parameter::name).collect(Collectors.toSet());
    }

    @Nullable
    static Parameter resolveKey(String parameter) {
        try {
            int pos = parameter.lastIndexOf(95);
            if (pos < 0 || pos > parameter.length() - 2) {
                return null;
            }
            ParameterName name = ParameterName.valueOf(parameter.substring(0, pos).toUpperCase());
            ParameterType type = ParameterType.valueOf(parameter.substring(pos + 1).toUpperCase());
            return new Parameter(name, type);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    @Nullable
    static Double resolveValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException ignore) {
            return null;
        }
    }

    private Double get(Parameter param) {
        return this.values.get(param);
    }

    public String toString() {
        ToStringBuilder buf = ToStringBuilder.of(DataOverlayParameters.class);
        List<String> keys = this.values.keySet().stream().map(Parameter::keyString).sorted().toList();
        for (String key : keys) {
            buf.addObj(key, (Object)this.get(key));
        }
        return buf.toString();
    }
}

