/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.actuator;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.ValidationError;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;

public class MicrometerGraphQLInstrumentation
implements Instrumentation {
    private static final String QUERY_TIME_METRIC_NAME = "graphql.timer.query";
    private static final String RESOLVER_TIME_METRIC_NAME = "graphql.timer.resolver";
    private static final String OPERATION_NAME_TAG = "operationName";
    private static final String OPERATION = "operation";
    private static final String PARENT = "parent";
    private static final String FIELD = "field";
    private static final String TIMER_DESCRIPTION = "Timer that records the time to fetch the data by Operation Name";
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;

    public MicrometerGraphQLInstrumentation(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new TraceState(parameters.getExecutionInput().getOperationName());
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(((TraceState)state).operationName, "execution")));
    }

    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(((TraceState)state).operationName, "parse")));
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> sample.stop(this.buildQueryTimer(((TraceState)state).operationName, "validation")));
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        return SimpleInstrumentationContext.noOp();
    }

    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        return new ExecutionStrategyInstrumentationContext(this){

            public void onDispatched() {
            }

            public void onCompleted(ExecutionResult result, Throwable t) {
            }
        };
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (parameters.getField().getDirective("timingData") == null) {
            return SimpleInstrumentationContext.noOp();
        }
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return SimpleInstrumentationContext.whenCompleted((res, err) -> {
            String parentType = GraphQLTypeUtil.simplePrint((GraphQLType)parameters.getExecutionStepInfo().getParent().getUnwrappedNonNullType());
            String fieldName = parameters.getExecutionStepInfo().getFieldDefinition().getName();
            sample.stop(this.buildFieldTimer(((TraceState)state).operationName, parentType, fieldName));
        });
    }

    private Timer buildQueryTimer(String operationName, String operation) {
        return Timer.builder((String)QUERY_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName).tag(OPERATION, operation).tags(this.tags).register(this.meterRegistry);
    }

    private Timer buildFieldTimer(String operationName, String parent, String field) {
        return Timer.builder((String)RESOLVER_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName).tag(PARENT, parent).tag(FIELD, field).tags(this.tags).register(this.meterRegistry);
    }

    private record TraceState(String operationName) implements InstrumentationState
    {
        private TraceState(String operationName) {
            this.operationName = operationName == null ? "__UNKNOWN__" : operationName;
        }
    }
}

