/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.actuator;

import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.updater.GraphUpdaterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/actuators")
public class ActuatorAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ActuatorAPI.class);
    public static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";
    public static final String CONTENT_TYPE_OPENMETRICS_100 = "application/openmetrics-text; version=1.0.0; charset=utf-8";

    @GET
    @Produces(value={"application/json"})
    public Response actuator(@Context UriInfo uriInfo) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)String.format("{\n  \"_links\" : {\n    \"self\" : {\n      \"href\" : \"%1$s\",\n      \"templated\" : false\n    },\n    \"health\" : {\n      \"href\" : \"%1$s/health\",\n      \"templated\" : false\n    },\n    \"prometheus\" : {\n      \"href\" : \"%1$s/prometheus\",\n      \"templated\" : false\n    }\n  }\n}", uriInfo.getRequestUri().toString().replace("$/", ""))).type("application/json").build();
    }

    @GET
    @Path(value="/health")
    @Produces(value={"application/json"})
    public Response health(@Context OtpServerRequestContext serverContext) {
        List<String> listUnprimedUpdaters;
        GraphUpdaterStatus updaterStatus = serverContext.transitService().getUpdaterStatus();
        if (updaterStatus != null && !(listUnprimedUpdaters = updaterStatus.listUnprimedUpdaters()).isEmpty()) {
            LOG.info("Graph ready, waiting for updaters: {}", listUnprimedUpdaters);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Graph ready, waiting for updaters: " + String.valueOf(listUnprimedUpdaters) + "\n")).type("text/plain").build());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"{\n  \"status\" : \"UP\"\n}").type("application/json").build();
    }

    @GET
    @Path(value="/prometheus")
    @Produces(value={"text/plain; version=0.0.4; charset=utf-8", "application/openmetrics-text; version=1.0.0; charset=utf-8"})
    public Response prometheus(@Context PrometheusMeterRegistry prometheusRegistry, @HeaderParam(value="Accept") @DefaultValue(value="*/*") String acceptHeader) {
        String contentType = acceptHeader.contains("application/openmetrics-text") ? CONTENT_TYPE_OPENMETRICS_100 : CONTENT_TYPE_004;
        return Response.status((Response.Status)Response.Status.OK).entity((Object)prometheusRegistry.scrape(contentType)).type(contentType).build();
    }
}

