/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.accessibilityscore;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLegBuilder;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class DecorateWithAccessibilityScore
implements ItineraryDecorator {
    private final double wheelchairMaxSlope;

    public DecorateWithAccessibilityScore(double wheelchairMaxSlope) {
        this.wheelchairMaxSlope = wheelchairMaxSlope;
    }

    @Override
    public Itinerary decorate(Itinerary itinerary) {
        return this.addAccessibilityScore(itinerary);
    }

    private Itinerary addAccessibilityScore(Itinerary i) {
        ItineraryBuilder builder = i.copyOf();
        builder.transformLegs(leg -> {
            if (leg instanceof ScheduledTransitLeg) {
                ScheduledTransitLeg transitLeg = (ScheduledTransitLeg)leg;
                return ((ScheduledTransitLegBuilder)transitLeg.copyOf().withAccessibilityScore(Float.valueOf(DecorateWithAccessibilityScore.compute(transitLeg)))).build();
            }
            if (leg instanceof StreetLeg) {
                StreetLeg streetLeg = (StreetLeg)leg;
                if (leg.isWalkingLeg()) {
                    return streetLeg.withAccessibilityScore(this.compute(streetLeg));
                }
            }
            return leg;
        });
        if (i.isWalkOnly() || i.hasTransit()) {
            builder.withAccessibilityScore(DecorateWithAccessibilityScore.compute(builder.legs()));
        }
        return builder.build();
    }

    private static float compute(ScheduledTransitLeg leg) {
        Accessibility fromStop = leg.from().stop.getWheelchairAccessibility();
        Accessibility toStop = leg.to().stop.getWheelchairAccessibility();
        Accessibility trip = leg.tripWheelchairAccessibility();
        List<Accessibility> values = List.of(trip, fromStop, toStop);
        float sum = (float)values.stream().mapToDouble(DecorateWithAccessibilityScore::accessibilityScore).sum();
        return sum / (float)values.size();
    }

    private static Float compute(List<Leg> legs) {
        return legs.stream().map(Leg::accessibilityScore).filter(Objects::nonNull).min(Comparator.comparingDouble(Float::doubleValue)).orElse(null);
    }

    private static double accessibilityScore(Accessibility wheelchair) {
        return switch (wheelchair) {
            default -> throw new MatchException(null, null);
            case Accessibility.NO_INFORMATION -> 0.5;
            case Accessibility.POSSIBLE -> 1.0;
            case Accessibility.NOT_POSSIBLE -> 0.0;
        };
    }

    private float compute(StreetLeg leg) {
        List<List> edges = leg.listWalkSteps().stream().map(WalkStep::getEdges).toList();
        List<StreetEdge> streetEdges = edges.stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).toList();
        double maxSlope = streetEdges.stream().filter(StreetEdge::hasElevationExtension).mapToDouble(StreetEdge::getMaxSlope).max().orElse(0.0);
        float score = 0.0f;
        double maxSlopeExceeded = streetEdges.stream().filter(s -> s.getMaxSlope() > maxSlope).mapToDouble(s -> s.getMaxSlope() - maxSlope).map(d -> d * 100.0).max().orElse(0.0);
        double slopeMalus = maxSlopeExceeded * maxSlopeExceeded / 10.0;
        score = (float)((double)score + (0.5 - slopeMalus));
        boolean allEdgesAreAccessible = edges.stream().filter(WheelchairTraversalInformation.class::isInstance).map(WheelchairTraversalInformation.class::cast).allMatch(WheelchairTraversalInformation::isWheelchairAccessible);
        if (allEdgesAreAccessible) {
            score += 0.5f;
        }
        return Math.max(score, 0.0f);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addNum("wheelchairMaxSlope", (Number)this.wheelchairMaxSlope).toString();
    }
}

