/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.https;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.https.HttpsDataSourceMetadata;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpsFileDataSource
implements DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsFileDataSource.class);
    private static final Duration HTTP_GET_REQUEST_TIMEOUT = Duration.ofSeconds(20L);
    private final URI uri;
    private final FileType type;
    private final HttpsDataSourceMetadata httpsDataSourceMetadata;
    private final OtpHttpClient otpHttpClient;

    HttpsFileDataSource(URI uri, FileType type, HttpsDataSourceMetadata httpsDataSourceMetadata) {
        this.uri = uri;
        this.type = type;
        this.httpsDataSourceMetadata = httpsDataSourceMetadata;
        this.otpHttpClient = new OtpHttpClientFactory().create(LOG);
    }

    @Override
    public long size() {
        return this.httpsDataSourceMetadata.contentLength();
    }

    @Override
    public long lastModified() {
        return this.httpsDataSourceMetadata.lastModified();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public InputStream asInputStream() {
        InputStream in;
        try {
            in = this.otpHttpClient.getAsInputStream(this.uri, HTTP_GET_REQUEST_TIMEOUT, Map.of());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
        if (this.httpsDataSourceMetadata().isGzipContentType() || this.uri.getPath().endsWith(".gz")) {
            try {
                return new GZIPInputStream(in);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }
        }
        return in;
    }

    @Override
    public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("Write operations are not available for HTTPS data sources");
    }

    @Override
    public String name() {
        return this.uri.getPath().substring(this.uri.getPath().lastIndexOf(47) + 1);
    }

    @Override
    public String path() {
        return this.uri.toString();
    }

    @Override
    public String directory() {
        int endIndex = this.path().lastIndexOf(this.name()) - 1;
        return endIndex <= 0 ? "" : this.path().substring(0, endIndex);
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public FileType type() {
        return this.type;
    }

    public HttpsDataSourceMetadata httpsDataSourceMetadata() {
        return this.httpsDataSourceMetadata;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HttpsFileDataSource that = (HttpsFileDataSource)obj;
        return Objects.equals(this.uri, that.uri) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.httpsDataSourceMetadata, that.httpsDataSourceMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.type, this.httpsDataSourceMetadata});
    }

    public String toString() {
        return "HttpsFileDataSource[uri=" + String.valueOf(this.uri) + ", type=" + String.valueOf((Object)this.type) + ", httpsDataSourceMetadata=" + String.valueOf(this.httpsDataSourceMetadata) + "]";
    }
}

